/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.teamresourceful.resourcefullib.common.utils.UnsafeUtils;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class EnumBuilder<T extends Enum<T>> {
    private static final Field ENUM_CONSTANTS = UnsafeUtils.getField(Class.class, field -> field.getName().equals("enumConstants"));
    private static final Field ENUM_CONSTANT_DIRECTORY = UnsafeUtils.getField(Class.class, field -> field.getName().equals("enumConstantDirectory"));
    private static final Predicate<Field> IS_SYNTHETIC = Field::isSynthetic;
    private static final Predicate<Field> IS_ARRAY = field -> field.getType().isArray();
    private static final Predicate<Field> IS_STATIC = field -> Modifier.isStatic(field.getModifiers());
    private static final Predicate<Field> NAMED_VALUES = field -> field.getName().contains("VALUES");
    private static final Predicate<Field> IS_VALUES_FIELD = IS_SYNTHETIC.and(IS_STATIC).and(IS_ARRAY).and(NAMED_VALUES);
    private final Class<T> enumClass;
    private final String id;
    private final List<Object> args = new ArrayList<Object>();
    private final List<Class<?>> types = new ArrayList();

    public EnumBuilder(Class<T> enumClass, String id) {
        this.enumClass = enumClass;
        this.id = id;
    }

    public static <T extends Enum<T>> EnumBuilder<T> of(Class<T> enumClass, String id) {
        return new EnumBuilder<T>(enumClass, id);
    }

    public EnumBuilder<T> withArg(Class<?> type, Object arg) {
        this.args.add(arg);
        this.types.add(type);
        return this;
    }

    public T build() throws Throwable {
        Class[] argTypes = new Class[this.types.size() + 2];
        argTypes[0] = String.class;
        argTypes[1] = Integer.TYPE;
        System.arraycopy(this.types.toArray(), 0, argTypes, 2, this.types.size());
        Object[] newArgs = new Object[this.args.size() + 2];
        newArgs[0] = this.id;
        newArgs[1] = ((Enum[])this.enumClass.getEnumConstants()).length;
        System.arraycopy(this.args.toArray(), 0, newArgs, 2, this.args.size());
        this.verify(argTypes, newArgs);
        return EnumBuilder.create(this.enumClass, newArgs, argTypes);
    }

    private void verify(Class<?>[] argTypes, Object[] newArgs) {
        if (argTypes.length != newArgs.length) {
            throw new IllegalArgumentException("Argument types and arguments must be the same length");
        }
    }

    private static <T extends Enum<T>> T create(Class<T> enumClass, Object[] args, Class<?>[] types) throws Throwable {
        Constructor<T> constructor = enumClass.getDeclaredConstructor(types);
        constructor.setAccessible(true);
        Enum output = (Enum)MethodHandles.lookup().unreflectConstructor(constructor).invokeWithArguments(args);
        Field valuesField = UnsafeUtils.getField(enumClass, field -> IS_VALUES_FIELD.test((Field)field) && field.getType().getComponentType().equals(enumClass));
        EnumBuilder.addArrayValue(valuesField, enumClass, output);
        UnsafeUtils.setField(enumClass, ENUM_CONSTANT_DIRECTORY, null);
        UnsafeUtils.setField(enumClass, ENUM_CONSTANTS, null);
        return (T)output;
    }

    public static <T> void addArrayValue(Field data, Class<T> object, T arrayEntry) {
        Object base = UnsafeUtils.unsafe().staticFieldBase(data);
        long offset = UnsafeUtils.unsafe().staticFieldOffset(data);
        Object[] array = (Object[])UnsafeUtils.unsafe().getObject(base, offset);
        Object[] newArray = (Object[])Array.newInstance(object, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = arrayEntry;
        UnsafeUtils.unsafe().putObject(base, offset, newArray);
    }
}

