/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.glue;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class SuperGlueEntity
extends Entity
implements IEntityAdditionalSpawnData,
ISpecialEntityItemRequirement {
    public static AABB span(BlockPos startPos, BlockPos endPos) {
        return new AABB(startPos, endPos).m_82363_(1.0, 1.0, 1.0);
    }

    public static boolean isGlued(LevelAccessor level, BlockPos blockPos, Direction direction, Set<SuperGlueEntity> cached) {
        BlockPos targetPos = blockPos.m_121945_(direction);
        if (cached != null) {
            for (SuperGlueEntity glueEntity : cached) {
                if (!glueEntity.contains(blockPos) || !glueEntity.contains(targetPos)) continue;
                return true;
            }
        }
        for (SuperGlueEntity glueEntity : level.m_45976_(SuperGlueEntity.class, SuperGlueEntity.span(blockPos, targetPos).m_82400_(16.0))) {
            if (!glueEntity.contains(blockPos) || !glueEntity.contains(targetPos)) continue;
            if (cached != null) {
                cached.add(glueEntity);
            }
            return true;
        }
        return false;
    }

    public static List<SuperGlueEntity> collectCropped(Level level, AABB bb) {
        ArrayList<SuperGlueEntity> glue = new ArrayList<SuperGlueEntity>();
        for (SuperGlueEntity glueEntity : level.m_45976_(SuperGlueEntity.class, bb)) {
            AABB glueBox = glueEntity.m_20191_();
            AABB intersect = bb.m_82323_(glueBox);
            if (intersect.m_82362_() * intersect.m_82376_() * intersect.m_82385_() == 0.0 || Mth.m_14082_((double)intersect.m_82309_(), (double)1.0)) continue;
            glue.add(new SuperGlueEntity(level, intersect));
        }
        return glue;
    }

    public SuperGlueEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public SuperGlueEntity(Level world, AABB boundingBox) {
        this((EntityType)AllEntityTypes.SUPER_GLUE.get(), world);
        this.m_20011_(boundingBox);
        this.resetPositionToBB();
    }

    public void resetPositionToBB() {
        AABB bb = this.m_20191_();
        this.m_20343_(bb.m_82399_().f_82479_, bb.f_82289_, bb.m_82399_().f_82481_);
    }

    protected void m_8097_() {
    }

    public static boolean isValidFace(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (BlockMovementChecks.isBlockAttachedTowards(state, world, pos, direction)) {
            return true;
        }
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return false;
        }
        return !BlockMovementChecks.isNotSupportive(state, direction);
    }

    public static boolean isSideSticky(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (AllBlocks.STICKY_MECHANICAL_PISTON.has(state)) {
            return state.m_61143_((Property)DirectionalKineticBlock.FACING) == direction;
        }
        if (AllBlocks.STICKER.has(state)) {
            return state.m_61143_((Property)DirectionalBlock.f_52588_) == direction;
        }
        if (state.m_60734_() == Blocks.f_50374_) {
            return true;
        }
        if (state.m_60734_() == Blocks.f_50719_) {
            return true;
        }
        if (AllBlocks.CART_ASSEMBLER.has(state)) {
            return Direction.UP == direction;
        }
        if (AllBlocks.GANTRY_CARRIAGE.has(state)) {
            return state.m_61143_((Property)DirectionalKineticBlock.FACING) == direction;
        }
        if (state.m_60734_() instanceof BearingBlock) {
            return state.m_61143_((Property)DirectionalKineticBlock.FACING) == direction;
        }
        if (state.m_60734_() instanceof AbstractChassisBlock) {
            BooleanProperty glueableSide = ((AbstractChassisBlock)state.m_60734_()).getGlueableSide(state, direction);
            if (glueableSide == null) {
                return false;
            }
            return (Boolean)state.m_61143_((Property)glueableSide);
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void m_8119_() {
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.f_19867_ = this.f_19787_;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.m_20191_().m_82362_() == 0.0) {
            this.m_146870_();
        }
    }

    public void m_6034_(double x, double y, double z) {
        AABB bb = this.m_20191_();
        this.m_20343_(x, y, z);
        Vec3 center = bb.m_82399_();
        this.m_20011_(bb.m_82386_(-center.f_82479_, -bb.f_82289_, -center.f_82481_).m_82386_(x, y, z));
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && pos.m_82556_() > 0.0) {
            this.m_146870_();
        }
    }

    public void m_5997_(double x, double y, double z) {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && x * x + y * y + z * z > 0.0) {
            this.m_146870_();
        }
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.0f;
    }

    public void playPlaceSound() {
        AllSoundEvents.SLIME_ADDED.playFrom(this, 0.5f, 0.75f);
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public void m_7380_(CompoundTag compound) {
        Vec3 position = this.m_20182_();
        SuperGlueEntity.writeBoundingBox(compound, this.m_20191_().m_82383_(position.m_82490_(-1.0)));
    }

    public void m_7378_(CompoundTag compound) {
        Vec3 position = this.m_20182_();
        this.m_20011_(SuperGlueEntity.readBoundingBox(compound).m_82383_(position));
    }

    public static void writeBoundingBox(CompoundTag compound, AABB bb) {
        compound.m_128365_("From", (Tag)VecHelper.writeNBT(new Vec3(bb.f_82288_, bb.f_82289_, bb.f_82290_)));
        compound.m_128365_("To", (Tag)VecHelper.writeNBT(new Vec3(bb.f_82291_, bb.f_82292_, bb.f_82293_)));
    }

    public static AABB readBoundingBox(CompoundTag compound) {
        Vec3 from = VecHelper.readNBT(compound.m_128437_("From", 6));
        Vec3 to = VecHelper.readNBT(compound.m_128437_("To", 6));
        return new AABB(from, to);
    }

    protected boolean m_6093_() {
        return false;
    }

    public float m_7890_(Rotation transformRotation) {
        AABB bb = this.m_20191_().m_82383_(this.m_20182_().m_82490_(-1.0));
        if (transformRotation == Rotation.CLOCKWISE_90 || transformRotation == Rotation.COUNTERCLOCKWISE_90) {
            this.m_20011_(new AABB(bb.f_82290_, bb.f_82289_, bb.f_82288_, bb.f_82293_, bb.f_82292_, bb.f_82291_).m_82383_(this.m_20182_()));
        }
        return super.m_7890_(transformRotation);
    }

    public float m_6961_(Mirror transformMirror) {
        return super.m_6961_(transformMirror);
    }

    public void m_8038_(ServerLevel world, LightningBolt lightningBolt) {
    }

    public void m_6210_() {
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        buffer.m_130079_(compound);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.DAMAGE, (Item)AllItems.SUPER_GLUE.get());
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean contains(BlockPos pos) {
        return this.m_20191_().m_82390_(Vec3.m_82512_((Vec3i)pos));
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void setPortalEntrancePos() {
        this.f_19819_ = this.m_20183_();
    }

    public PortalInfo m_7937_(ServerLevel pDestination) {
        return super.m_7937_(pDestination);
    }

    public void spawnParticles() {
        AABB bb = this.m_20191_();
        Vec3 origin = new Vec3(bb.f_82288_, bb.f_82289_, bb.f_82290_);
        Vec3 extents = new Vec3(bb.m_82362_(), bb.m_82376_(), bb.m_82385_());
        Direction.Axis[] axisArray = this.m_9236_();
        if (!(axisArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel slevel = (ServerLevel)axisArray;
        block0: for (Direction.Axis axis : Iterate.axes) {
            Direction.AxisDirection positive = Direction.AxisDirection.POSITIVE;
            double max = axis.m_6150_(extents.f_82479_, extents.f_82480_, extents.f_82481_);
            Vec3 normal = Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)positive).m_122436_());
            for (Direction.Axis axis2 : Iterate.axes) {
                if (axis2 == axis) continue;
                double max2 = axis2.m_6150_(extents.f_82479_, extents.f_82480_, extents.f_82481_);
                Vec3 normal2 = Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axis2, (Direction.AxisDirection)positive).m_122436_());
                for (Direction.Axis axis3 : Iterate.axes) {
                    if (axis3 == axis2 || axis3 == axis) continue;
                    double max3 = axis3.m_6150_(extents.f_82479_, extents.f_82480_, extents.f_82481_);
                    Vec3 normal3 = Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axis3, (Direction.AxisDirection)positive).m_122436_());
                    int i = 0;
                    while ((double)i <= max * 2.0) {
                        for (int o1 : Iterate.zeroAndOne) {
                            for (int o2 : Iterate.zeroAndOne) {
                                Vec3 v = origin.m_82549_(normal.m_82490_((double)((float)i / 2.0f))).m_82549_(normal2.m_82490_(max2 * (double)o1)).m_82549_(normal3.m_82490_(max3 * (double)o2));
                                slevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, v.f_82479_, v.f_82480_, v.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                        ++i;
                    }
                    continue block0;
                }
                continue block0;
            }
        }
    }
}

