/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.outliner.ChasingAABBOutline;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Components;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ValueBox
extends ChasingAABBOutline {
    protected Component label;
    protected Component sublabel = Components.immutableEmpty();
    protected Component scrollTooltip = Components.immutableEmpty();
    protected Vec3 labelOffset = Vec3.f_82478_;
    public int overrideColor = -1;
    public boolean isPassive;
    protected BlockPos pos;
    protected ValueBoxTransform transform;
    protected BlockState blockState;
    protected AllIcons outline = AllIcons.VALUE_BOX_HOVER_4PX;

    public ValueBox(Component label, AABB bb, BlockPos pos) {
        this(label, bb, pos, Minecraft.m_91087_().f_91073_.m_8055_(pos));
    }

    public ValueBox(Component label, AABB bb, BlockPos pos, BlockState state) {
        super(bb);
        this.label = label;
        this.pos = pos;
        this.blockState = state;
    }

    public ValueBox transform(ValueBoxTransform transform) {
        this.transform = transform;
        return this;
    }

    public ValueBox wideOutline() {
        this.outline = AllIcons.VALUE_BOX_HOVER_6PX;
        return this;
    }

    public ValueBox passive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    public ValueBox withColor(int color) {
        this.overrideColor = color;
        return this;
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt) {
        boolean hasTransform;
        boolean bl = hasTransform = this.transform != null;
        if (this.transform instanceof ValueBoxTransform.Sided && this.params.getHighlightedFace() != null) {
            ((ValueBoxTransform.Sided)this.transform).fromSide(this.params.getHighlightedFace());
        }
        if (hasTransform && !this.transform.shouldRender(this.blockState)) {
            return;
        }
        ms.m_85836_();
        ms.m_85837_((double)this.pos.m_123341_() - camera.f_82479_, (double)this.pos.m_123342_() - camera.f_82480_, (double)this.pos.m_123343_() - camera.f_82481_);
        if (hasTransform) {
            this.transform.transform(this.blockState, ms);
        }
        if (!this.isPassive) {
            ms.m_85836_();
            ms.m_85841_(-2.01f, -2.01f, 2.01f);
            ms.m_85837_(-0.5, -0.5, -0.03125);
            this.getOutline().render(ms, buffer, 0xFFFFFF);
            ms.m_85849_();
        }
        float fontScale = hasTransform ? -this.transform.getFontScale() : -0.015625f;
        ms.m_85841_(fontScale, fontScale, fontScale);
        this.renderContents(ms, buffer);
        ms.m_85849_();
    }

    public AllIcons getOutline() {
        return this.outline;
    }

    public void renderContents(PoseStack ms, MultiBufferSource buffer) {
    }

    protected void renderHoveringText(PoseStack ms, MultiBufferSource buffer, Component text, int color) {
        ms.m_85836_();
        ValueBox.drawString(ms, buffer, text, 0.0f, 0.0f, color);
        ms.m_85849_();
    }

    private static void drawString(PoseStack ms, MultiBufferSource buffer, Component text, float x, float y, int color) {
        Minecraft.m_91087_().f_91062_.m_272077_(text, x, y, color, false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static class IconValueBox
    extends ValueBox {
        AllIcons icon;

        public IconValueBox(Component label, INamedIconOptions iconValue, AABB bb, BlockPos pos) {
            super(label, bb, pos);
            this.icon = iconValue.getIcon();
        }

        @Override
        public void renderContents(PoseStack ms, MultiBufferSource buffer) {
            super.renderContents(ms, buffer);
            float scale = 32.0f;
            ms.m_85841_(scale, scale, scale);
            ms.m_252880_(-0.5f, -0.5f, 0.15625f);
            int overrideColor = this.transform.getOverrideColor();
            this.icon.render(ms, buffer, overrideColor != -1 ? overrideColor : 0xFFFFFF);
        }
    }

    public static class TextValueBox
    extends ValueBox {
        Component text;

        public TextValueBox(Component label, AABB bb, BlockPos pos, Component text) {
            super(label, bb, pos);
            this.text = text;
        }

        public TextValueBox(Component label, AABB bb, BlockPos pos, BlockState state, Component text) {
            super(label, bb, pos, state);
            this.text = text;
        }

        @Override
        public void renderContents(PoseStack ms, MultiBufferSource buffer) {
            boolean singleDigit;
            super.renderContents(ms, buffer);
            Font font = Minecraft.m_91087_().f_91062_;
            float scale = 3.0f;
            ms.m_85841_(scale, scale, 1.0f);
            ms.m_85837_(-4.0, -3.75, 5.0);
            int stringWidth = font.m_92852_((FormattedText)this.text);
            Objects.requireNonNull(font);
            float numberScale = 9.0f / (float)stringWidth;
            boolean bl = singleDigit = stringWidth < 10;
            if (singleDigit) {
                numberScale /= 2.0f;
            }
            Objects.requireNonNull(font);
            float verticalMargin = (float)(stringWidth - 9) / 2.0f;
            ms.m_85841_(numberScale, numberScale, numberScale);
            ms.m_252880_(singleDigit ? (float)(stringWidth / 2) : 0.0f, singleDigit ? -verticalMargin : verticalMargin, 0.0f);
            int overrideColor = this.transform.getOverrideColor();
            this.renderHoveringText(ms, buffer, this.text, overrideColor != -1 ? overrideColor : 0xEDEDED);
        }
    }

    public static class ItemValueBox
    extends ValueBox {
        ItemStack stack;
        int count;
        boolean upTo;

        public ItemValueBox(Component label, AABB bb, BlockPos pos, ItemStack stack, int count, boolean upTo) {
            super(label, bb, pos);
            this.stack = stack;
            this.count = count;
            this.upTo = upTo;
        }

        @Override
        public AllIcons getOutline() {
            if (!this.stack.m_41619_()) {
                return AllIcons.VALUE_BOX_HOVER_6PX;
            }
            return super.getOutline();
        }

        @Override
        public void renderContents(PoseStack ms, MultiBufferSource buffer) {
            super.renderContents(ms, buffer);
            if (this.count == -1) {
                return;
            }
            Font font = Minecraft.m_91087_().f_91062_;
            boolean wildcard = this.count == 0 || this.upTo && this.count >= this.stack.m_41741_();
            MutableComponent countString = Components.literal((String)(wildcard ? "*" : "" + this.count));
            ms.m_252880_(17.5f, -5.0f, 7.0f);
            boolean isFilter = this.stack.m_41720_() instanceof FilterItem;
            boolean isEmpty = this.stack.m_41619_();
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            BakedModel modelWithOverrides = itemRenderer.m_174264_(this.stack, null, null, 0);
            boolean blockItem = modelWithOverrides.m_7539_() && modelWithOverrides.getRenderPasses(this.stack, false).size() <= 1;
            float scale = 1.5f;
            ms.m_252880_((float)(-font.m_92852_((FormattedText)countString)), 0.0f, 0.0f);
            if (isFilter) {
                ms.m_252880_(-5.0f, 8.0f, 7.25f);
            } else if (isEmpty) {
                ms.m_252880_(-15.0f, -1.0f, -2.75f);
                scale = 1.65f;
            } else {
                ms.m_252880_(-7.0f, 10.0f, blockItem ? 10.25f : 0.0f);
            }
            if (wildcard) {
                ms.m_252880_(-1.0f, 3.0f, 0.0f);
            }
            ms.m_85841_(scale, scale, scale);
            ValueBox.drawString(ms, buffer, (Component)countString, 0.0f, 0.0f, isFilter ? 0xFFFFFF : 0xEDEDED);
            ms.m_252880_(0.0f, 0.0f, -0.0625f);
            ValueBox.drawString(ms, buffer, (Component)countString, 0.875f, 0.875f, 0x4F4F4F);
        }
    }
}

