/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.FacingBlock;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StorageBlock
extends FacingBlock
implements EntityBlock {
    public static final SoundEvent event = SoundEvents.f_12635_;

    public StorageBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof StorageBlockEntity)) {
            return InteractionResult.PASS;
        }
        StorageBlockEntity shelfBlockEntity = (StorageBlockEntity)blockEntity;
        Optional<Tuple<Float, Float>> optional = Util.getRelativeHitCoordinatesForBlockFace(hit, (Direction)state.m_61143_((Property)f_54117_), this.unAllowedDirections());
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        Tuple<Float, Float> ff = optional.get();
        int i = this.getSection((Float)ff.m_14418_(), (Float)ff.m_14419_());
        if (i == Integer.MIN_VALUE || i >= shelfBlockEntity.getInventory().size()) {
            return InteractionResult.PASS;
        }
        if (!((ItemStack)shelfBlockEntity.getInventory().get(i)).m_41619_()) {
            this.remove(world, pos, player, shelfBlockEntity, i);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.canInsertStack(stack)) {
            this.add(world, pos, player, shelfBlockEntity, stack, i);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public void add(Level level, BlockPos blockPos, Player player, StorageBlockEntity shelfBlockEntity, ItemStack itemStack, int i) {
        if (!level.f_46443_) {
            SoundEvent soundEvent = this.getAddSound(level, blockPos, player, i);
            shelfBlockEntity.setStack(i, itemStack.m_41620_(1));
            level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player.m_7500_()) {
                itemStack.m_41769_(1);
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
        }
    }

    public void remove(Level level, BlockPos blockPos, Player player, StorageBlockEntity shelfBlockEntity, int i) {
        if (!level.f_46443_) {
            ItemStack itemStack = shelfBlockEntity.removeStack(i);
            SoundEvent soundEvent = this.getRemoveSound(level, blockPos, player, i);
            level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_150109_().m_36054_(itemStack)) {
                player.m_36176_(itemStack, false);
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
        }
    }

    public SoundEvent getRemoveSound(Level level, BlockPos blockPos, Player player, int i) {
        return event;
    }

    public SoundEvent getAddSound(Level level, BlockPos blockPos, Player player, int i) {
        return event;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof StorageBlockEntity) {
                StorageBlockEntity shelf = (StorageBlockEntity)blockEntity;
                if (world instanceof ServerLevel) {
                    Containers.m_19010_((Level)world, (BlockPos)pos, shelf.getInventory());
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public abstract int size();

    public abstract ResourceLocation type();

    public abstract Direction[] unAllowedDirections();

    public abstract boolean canInsertStack(ItemStack var1);

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StorageBlockEntity(pos, state, this.size());
    }

    public abstract int getSection(Float var1, Float var2);
}

