/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block.entity;

import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CabinetBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter stateManager;

    public CabinetBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, SoundEvents.f_11749_, SoundEvents.f_11747_);
    }

    public CabinetBlockEntity(BlockPos pos, BlockState state, final SoundEvent openSound, final SoundEvent closeSound) {
        super((BlockEntityType)DoApiBlockEntityTypes.CABINET_BLOCK_ENTITY.get(), pos, state);
        this.stateManager = new ContainerOpenersCounter(){

            protected void m_142292_(Level world, BlockPos pos, BlockState state) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)), 3);
                assert (CabinetBlockEntity.this.f_58857_ != null);
                1.playSound(CabinetBlockEntity.this.f_58857_, pos, openSound);
            }

            protected void m_142289_(Level world, BlockPos pos, BlockState state) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false)), 3);
                assert (CabinetBlockEntity.this.f_58857_ != null);
                1.playSound(CabinetBlockEntity.this.f_58857_, pos, closeSound);
            }

            static void playSound(Level level, BlockPos blockPos, SoundEvent soundEvent) {
                double d = (double)blockPos.m_123341_() + 0.5;
                double e = (double)blockPos.m_123342_() + 0.5;
                double f = (double)blockPos.m_123343_() + 0.5;
                level.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.7f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            }

            protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
            }

            protected boolean m_142718_(Player player) {
                if (player.f_36096_ instanceof ChestMenu) {
                    Container inventory = ((ChestMenu)player.f_36096_).m_39261_();
                    return inventory == CabinetBlockEntity.this;
                }
                return false;
            }
        };
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    public int m_6643_() {
        return 36;
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new ChestMenu(MenuType.f_39960_, syncId, playerInventory, (Container)this, 4);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void tick() {
        if (!this.f_58859_) {
            this.stateManager.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void setOpen(BlockState state, boolean open) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(open)), 3);
    }
}

