/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import dev.ithundxr.createnumismatics.base.block.NotifyFailedBreak;
import dev.ithundxr.createnumismatics.content.backend.TrustedBlock;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlockEntities;
import dev.ithundxr.createnumismatics.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendorBlock
extends Block
implements IBE<VendorBlockEntity>,
TrustedBlock,
IWrenchable,
NotifyFailedBreak {
    VoxelShape voxelShape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)18.0, (double)15.0));
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public final boolean isCreativeVendor;

    public VendorBlock(BlockBehaviour.Properties properties, boolean isCreativeVendor) {
        super(properties);
        this.isCreativeVendor = isCreativeVendor;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING});
    }

    public Class<VendorBlockEntity> getBlockEntityClass() {
        return VendorBlockEntity.class;
    }

    public BlockEntityType<? extends VendorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NumismaticsBlockEntities.VENDOR.get();
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof VendorBlockEntity) {
                VendorBlockEntity vendorBlockEntity = (VendorBlockEntity)blockEntity;
                vendorBlockEntity.owner = player.m_20148_();
            }
        }
    }

    @Override
    public void notifyFailedBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VendorBlockEntity) {
            VendorBlockEntity vendorBlockEntity = (VendorBlockEntity)blockEntity;
            vendorBlockEntity.notifyDelayedDataSync();
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof VendorBlockEntity) {
            VendorBlockEntity vbe = (VendorBlockEntity)blockEntity;
            vbe.dropContents(level, pos);
            level.m_46717_(pos, (Block)this);
        }
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!this.isTrusted(context.m_43723_(), (BlockGetter)context.m_43725_(), context.m_8083_())) {
            return InteractionResult.FAIL;
        }
        return super.onSneakWrenched(state, context);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.m_6047_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (this.isTrusted(player, (BlockGetter)level, pos)) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> Utils.openScreen((ServerPlayer)player, be, arg_0 -> ((VendorBlockEntity)be).sendToMenu(arg_0)));
            }
            return InteractionResult.SUCCESS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> be.tryTransaction(player, hand));
        return InteractionResult.CONSUME;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        if (!this.isTrusted(player, level, pos)) {
            return 0.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.voxelShape;
    }
}

