/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.handler;

import dev.ithundxr.createnumismatics.annotation.mixin.ConditionalMixin;
import dev.ithundxr.createnumismatics.annotation.mixin.DevMixin;
import dev.ithundxr.createnumismatics.compat.Mods;
import dev.ithundxr.createnumismatics.util.Utils;
import java.io.IOException;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class ConditionalMixinHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Numismatics/MixinPlugin");

    public static boolean shouldApply(String className) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)className).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            boolean shouldApply = true;
            for (AnnotationNode node : annotationNodes) {
                if (node.desc.equals(Type.getDescriptor(ConditionalMixin.class))) {
                    List mods = Annotations.getValue((AnnotationNode)node, (String)"mods", (boolean)true, Mods.class);
                    boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                    boolean anyModsLoaded = ConditionalMixinHandler.anyModsLoaded(mods);
                    shouldApply = anyModsLoaded == applyIfPresent;
                    LOGGER.debug("{} is{}being applied because the mod(s) {} are{}loaded", new Object[]{className, shouldApply ? " " : " not ", mods, anyModsLoaded ? " " : " not "});
                }
                if (!node.desc.equals(Type.getDescriptor(DevMixin.class))) continue;
                shouldApply &= Utils.isDevEnv();
            }
            return shouldApply;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean anyModsLoaded(List<Mods> mods) {
        for (Mods mod : mods) {
            if (!mod.isLoaded) continue;
            return true;
        }
        return false;
    }
}

