/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.packets;

import dev.ithundxr.createnumismatics.content.vendor.VendorMenu;
import dev.ithundxr.createnumismatics.multiloader.S2CPacket;
import dev.ithundxr.createnumismatics.util.PacketUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VendorContainerSetContentPacket
implements S2CPacket {
    private final int containerId;
    private final int stateId;
    private final List<ItemStack> items;
    private final ItemStack carriedItem;

    public VendorContainerSetContentPacket(int containerId, int stateId, List<ItemStack> items, ItemStack carriedItem) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.items = NonNullList.m_122780_((int)items.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, items.get(i).m_41777_());
        }
        this.carriedItem = carriedItem;
    }

    public VendorContainerSetContentPacket(FriendlyByteBuf buffer) {
        this.containerId = buffer.readUnsignedByte();
        this.stateId = buffer.m_130242_();
        this.items = (List)buffer.m_236838_(NonNullList::m_182647_, PacketUtils::readHighCountItem);
        this.carriedItem = buffer.m_130267_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.containerId);
        buffer.m_130130_(this.stateId);
        buffer.m_236828_(this.items, PacketUtils::writeHighCountItem);
        buffer.m_130055_(this.carriedItem);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        if (player.f_36096_ != null && player.f_36096_ instanceof VendorMenu && player.f_36096_.f_38840_ == this.containerId) {
            player.f_36096_.m_182410_(this.stateId, this.items, this.carriedItem);
        }
    }
}

