/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.forge.handler;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MissingMappingsHandler {
    @SubscribeEvent
    public static void onMissingMapping(MissingMappingsEvent event) {
        Remapper.create(Registries.f_256747_).remap("white_cherry_sapling", BOPBlocks.SNOWBLOSSOM_SAPLING).remap("white_cherry_leaves", BOPBlocks.SNOWBLOSSOM_LEAVES).remap("pink_cherry_sapling", Blocks.f_271334_).remap("pink_cherry_leaves", Blocks.f_271115_).remap("cherry_log", Blocks.f_271170_).remap("cherry_wood", Blocks.f_271348_).remap("stripped_cherry_log", Blocks.f_271326_).remap("stripped_cherry_wood", Blocks.f_271145_).remap("cherry_planks", Blocks.f_271304_).remap("cherry_stairs", Blocks.f_271206_).remap("cherry_slab", Blocks.f_271301_).remap("cherry_fence", Blocks.f_271219_).remap("cherry_fence_gate", Blocks.f_271274_).remap("cherry_door", Blocks.f_271169_).remap("cherry_trapdoor", Blocks.f_271350_).remap("cherry_pressure_plate", Blocks.f_271227_).remap("cherry_button", Blocks.f_271396_).remap("cherry_sign", Blocks.f_271516_).remap("cherry_wall_sign", Blocks.f_271107_).remap("potted_white_cherry_sapling", BOPBlocks.POTTED_SNOWBLOSSOM_SAPLING).remap("potted_pink_cherry_sapling", Blocks.f_271106_).remap("maple_sapling", BOPBlocks.RED_MAPLE_SAPLING).remap("orange_autumn_sapling", BOPBlocks.ORANGE_MAPLE_SAPLING).remap("yellow_autumn_sapling", BOPBlocks.YELLOW_MAPLE_SAPLING).remap("maple_leaves", BOPBlocks.RED_MAPLE_LEAVES).remap("orange_autumn_leaves", BOPBlocks.ORANGE_MAPLE_LEAVES).remap("yellow_autumn_leaves", BOPBlocks.YELLOW_MAPLE_LEAVES).remap("potted_maple_sapling", BOPBlocks.POTTED_RED_MAPLE_SAPLING).remap("potted_orange_autumn_sapling", BOPBlocks.POTTED_ORANGE_MAPLE_SAPLING).remap("potted_yellow_autumn_sapling", BOPBlocks.POTTED_YELLOW_MAPLE_SAPLING).remap("mud", Blocks.f_220864_).remap("mud_bricks", Blocks.f_220844_).remap("mud_brick_block", Blocks.f_220844_).remap("mud_brick_stairs", Blocks.f_220845_).remap("mud_brick_slab", Blocks.f_220849_).remap("mud_brick_wall", Blocks.f_220854_).remap("loamy_grass_block", Blocks.f_50440_).remap("loamy_dirt", Blocks.f_50493_).remap("coarse_loamy_dirt", Blocks.f_50546_).remap("loamy_grass_path", Blocks.f_152481_).remap("loamy_farmland", Blocks.f_50093_).remap("silty_grass_block", Blocks.f_50440_).remap("silty_dirt", Blocks.f_50493_).remap("coarse_silty_dirt", Blocks.f_50546_).remap("silty_grass_path", Blocks.f_152481_).remap("silty_farmland", Blocks.f_50093_).remap("sandy_grass_block", Blocks.f_50440_).remap("sandy_dirt", Blocks.f_50493_).remap("coarse_sandy_dirt", Blocks.f_50546_).remap("sandy_grass_path", Blocks.f_152481_).remap("sandy_farmland", Blocks.f_50093_).remap("overgrown_black_sand", BOPBlocks.MOSSY_BLACK_SAND).remap("dried_sand", BOPBlocks.DRIED_SALT).remap("ash_block", Blocks.f_50137_).remap("rooted_sand", Blocks.f_49992_).remap("root", Blocks.f_152548_).remap("nether_sprout", BOPBlocks.SPROUT).remap("tall_cattail", BOPBlocks.CATTAIL).remap("ivy", BOPBlocks.WILLOW_VINE).remap("grass", Blocks.f_50034_).remap("thorn", Blocks.f_50036_).remap("deathbloom", Blocks.f_50070_).remap("devilweed", BOPBlocks.SPROUT).remap("flowering_sapling", BOPBlocks.FLOWERING_OAK_SAPLING).remap("flowering_leaves", BOPBlocks.FLOWERING_OAK_LEAVES).remap("nether_crystal_block", BOPBlocks.ROSE_QUARTZ_BLOCK).remap("nether_crystal", BOPBlocks.ROSE_QUARTZ_CLUSTER).remap("tall_wheat", BOPBlocks.BARLEY).remap("potted_clover", Blocks.f_50276_).remap("potted_wildflower", Blocks.f_50276_).run(event);
        Remapper.create(Registries.f_256913_).remap("cherry_sign", Items.f_271504_).remap("cherry_boat", Items.f_271386_).remap("cherry_chest_boat", Items.f_271490_).remap("record_wanderer", BOPItems.MUSIC_DISC_WANDERER).remap("rose_quartz_shard", BOPItems.ROSE_QUARTZ_CHUNK).run(event);
        Remapper.create(Registries.f_256952_).remap("alps", Biomes.f_186758_).remap("alps_foothills", Biomes.f_186755_).remap("ashen_inferno", BOPBiomes.ERUPTING_INFERNO).remap("aspen_forest", BOPBiomes.ASPEN_GLADE).remap("bamboo_grove", (ResourceKey<Biome>)Biomes.f_271432_).remap("bamboo_blossom_grove", (ResourceKey<Biome>)Biomes.f_271432_).remap("bayou_mangrove", BOPBiomes.BAYOU).remap("boreal_forest", BOPBiomes.ASPEN_GLADE).remap("brushland", BOPBiomes.DRYLAND).remap("burnt_forest", BOPBiomes.OLD_GROWTH_DEAD_FOREST).remap("chaparral", BOPBiomes.ROCKY_SHRUBLAND).remap("cherry_blossom_grove", (ResourceKey<Biome>)Biomes.f_271432_).remap("clover_patch", BOPBiomes.GRASSLAND).remap("coniferous_lakes", BOPBiomes.CONIFEROUS_FOREST).remap("dead_swamp", (ResourceKey<Biome>)Biomes.f_48207_).remap("deep_bayou", BOPBiomes.BAYOU).remap("dense_marsh", BOPBiomes.MARSH).remap("dense_woodland", BOPBiomes.OLD_GROWTH_WOODLAND).remap("dry_boneyard", BOPBiomes.DRYLAND).remap("dry_plains", BOPBiomes.SCRUBLAND).remap("dry_steppe", BOPBiomes.DRYLAND).remap("dunes", BOPBiomes.DUNE_BEACH).remap("flower_meadow", BOPBiomes.FIELD).remap("fungal_field", BOPBiomes.FUNGAL_JUNGLE).remap("ghost_forest", BOPBiomes.MUSKEG).remap("glowstone_grotto", BOPBiomes.CRYSTALLINE_CHASM).remap("golden_prairie", BOPBiomes.PASTURE).remap("grassland_clover_patch", BOPBiomes.GRASSLAND).remap("gravel_beach", (ResourceKey<Biome>)Biomes.f_186760_).remap("grove", BOPBiomes.MEDITERRANEAN_FOREST).remap("grove_clearing", BOPBiomes.MEDITERRANEAN_FOREST).remap("grove_lakes", BOPBiomes.MEDITERRANEAN_FOREST).remap("highland_crag", BOPBiomes.CRAG).remap("highland_moor", BOPBiomes.MOOR).remap("infernal_ashlands", BOPBiomes.ERUPTING_INFERNO).remap("jacaranda_forest", BOPBiomes.JACARANDA_GLADE).remap("lavender_forest", BOPBiomes.JACARANDA_GLADE).remap("lush_grassland", (ResourceKey<Biome>)Biomes.f_186769_).remap("lush_swamp", (ResourceKey<Biome>)Biomes.f_48207_).remap("mangrove", (ResourceKey<Biome>)Biomes.f_220595_).remap("meadow", BOPBiomes.FIELD).remap("meadow_forest", BOPBiomes.FORESTED_FIELD).remap("mediterranean_lakes", BOPBiomes.MEDITERRANEAN_FOREST).remap("mire", BOPBiomes.MUSKEG).remap("mystic_plains", BOPBiomes.MYSTIC_GROVE).remap("oasis", (ResourceKey<Biome>)Biomes.f_48203_).remap("ominous_mire", BOPBiomes.OMINOUS_WOODS).remap("origin_beach", BOPBiomes.ORIGIN_VALLEY).remap("origin_hills", BOPBiomes.ORIGIN_VALLEY).remap("outback", BOPBiomes.LUSH_DESERT).remap("overgrown_cliffs", BOPBiomes.ROCKY_RAINFOREST).remap("poppy_field", BOPBiomes.LUSH_SAVANNA).remap("rainbow_hills", BOPBiomes.AURORAL_GARDEN).remap("rainbow_valley", BOPBiomes.AURORAL_GARDEN).remap("rainforest_cliffs", BOPBiomes.ROCKY_RAINFOREST).remap("rainforest_floodplain", BOPBiomes.FLOODPLAIN).remap("redwood_forest_edge", BOPBiomes.REDWOOD_FOREST).remap("redwood_hills", BOPBiomes.REDWOOD_FOREST).remap("seasonal_orchard", BOPBiomes.ASPEN_GLADE).remap("seasonal_pumpkin_patch", BOPBiomes.PUMPKIN_PATCH).remap("shadowlands", BOPBiomes.WITHERED_ABYSS).remap("shield", BOPBiomes.CONIFEROUS_FOREST).remap("shroomy_wetland", BOPBiomes.WETLAND).remap("shrubland_hills", BOPBiomes.ROCKY_SHRUBLAND).remap("silkglade", BOPBiomes.WETLAND).remap("snowy_forest", BOPBiomes.SNOWY_MAPLE_WOODS).remap("steppe", BOPBiomes.WASTELAND_STEPPE).remap("tall_dead_forest", BOPBiomes.OLD_GROWTH_DEAD_FOREST).remap("temperate_rainforest", BOPBiomes.REDWOOD_FOREST).remap("temperate_rainforest_hills", BOPBiomes.REDWOOD_FOREST).remap("tropic_beach", BOPBiomes.TROPICS).remap("tropical_rainforest", BOPBiomes.RAINFOREST).remap("tundra_basin", BOPBiomes.TUNDRA).remap("tundra_bog", BOPBiomes.BOG).remap("undergarden", BOPBiomes.UNDERGROWTH).remap("volcano_edge", BOPBiomes.VOLCANO).remap("wetland_forest", BOPBiomes.WETLAND).remap("white_beach", BOPBiomes.TROPICS).remap("wooded_scrubland", BOPBiomes.SCRUBLAND).remap("wooded_wasteland", BOPBiomes.WASTELAND).remap("xeric_shrubland", BOPBiomes.DRYLAND).run(event);
    }

    private static class Remapper<T> {
        private final ResourceKey<Registry<T>> registryKey;
        private Map<ResourceLocation, T> remaps = new HashMap<ResourceLocation, T>();
        private Map<ResourceLocation, ResourceKey<T>> remapResourceKeys = new HashMap<ResourceLocation, ResourceKey<T>>();

        private Remapper(ResourceKey<Registry<T>> registryKey) {
            this.registryKey = registryKey;
        }

        public static <T> Remapper<T> create(ResourceKey<Registry<T>> registry) {
            return new Remapper<T>(registry);
        }

        public Remapper<T> remap(String oldId, T replacement) {
            this.remaps.put(new ResourceLocation("biomesoplenty", oldId), replacement);
            return this;
        }

        public Remapper<T> remap(String oldId, RegistryObject<T> replacement) {
            return this.remap(oldId, replacement.get());
        }

        public Remapper<T> remap(String oldId, ResourceKey<T> replacement) {
            this.remapResourceKeys.put(new ResourceLocation("biomesoplenty", oldId), replacement);
            return this;
        }

        public void run(MissingMappingsEvent event) {
            for (MissingMappingsEvent.Mapping mapping : event.getMappings(this.registryKey, "biomesoplenty")) {
                ResourceKey<T> replacement;
                IForgeRegistry registry;
                if (this.remaps.containsKey(mapping.getKey())) {
                    mapping.remap(this.remaps.get(mapping.getKey()));
                    continue;
                }
                if (!this.remapResourceKeys.containsKey(mapping.getKey()) || !(registry = mapping.getRegistry()).containsKey((replacement = this.remapResourceKeys.get(mapping.getKey())).m_135782_())) continue;
                mapping.remap(registry.getValue(replacement.m_135782_()));
            }
            if (this.registryKey == Registries.f_256747_) {
                for (MissingMappingsEvent.Mapping mapping : event.getMappings(Registries.f_256913_, "biomesoplenty")) {
                    if (!this.remaps.containsKey(mapping.getKey())) continue;
                    Block block = (Block)this.remaps.get(mapping.getKey());
                    mapping.remap((Object)block.m_5456_());
                }
            }
        }
    }
}

