/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.github.talrey.createdeco.BlockRegistry;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShippingContainerBlock
extends ItemVaultBlock {
    public final DyeColor COLOR;
    public static final SoundType SILENCED_METAL = new SoundType(0.1f, 1.5f, SoundEvents.f_12198_, SoundEvents.f_12199_, SoundEvents.f_12200_, SoundEvents.f_12201_, SoundEvents.f_12202_);

    public ShippingContainerBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.COLOR = color;
    }

    public static DyeColor getColor(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof ShippingContainerBlock) {
            ShippingContainerBlock scb = (ShippingContainerBlock)block;
            return scb.COLOR;
        }
        return DyeColor.BLUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameType(BlockState other) {
        Block block = other.m_60734_();
        if (!(block instanceof ShippingContainerBlock)) return false;
        ShippingContainerBlock container = (ShippingContainerBlock)block;
        if (container.COLOR != this.COLOR) return false;
        return true;
    }

    public static boolean isVault(BlockState state) {
        return state.m_60734_() instanceof ShippingContainerBlock;
    }

    public static boolean isLarge(BlockState state) {
        if (!ShippingContainerBlock.isVault(state)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)LARGE);
    }

    @Nullable
    public static Direction.Axis getVaultBlockAxis(BlockState state) {
        if (!ShippingContainerBlock.isVault(state)) {
            return null;
        }
        return (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public BlockEntityType<? extends ItemVaultBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockRegistry.CONTAINER_ENTITIES.get(this.COLOR).get();
    }

    public static class Entity
    extends ItemVaultBlockEntity {
        public Entity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public Entity getControllerBE() {
            ItemVaultBlockEntity be = super.getControllerBE();
            if (be instanceof Entity) {
                Entity container = (Entity)be;
                return container;
            }
            return null;
        }

        protected void updateConnectivity() {
            this.updateConnectivity = false;
            if (this.f_58857_.m_5776_()) {
                return;
            }
            if (!this.isController()) {
                return;
            }
            ConnectivityHandler.formMulti((BlockEntity)this);
        }

        public void notifyMultiUpdated() {
            BlockState state = this.m_58900_();
            if (ShippingContainerBlock.isVault(state)) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
            }
            super.notifyMultiUpdated();
        }

        public void removeController(boolean keepContents) {
            super.removeController(keepContents);
            BlockState state = this.m_58900_();
            state = (BlockState)state.m_61124_((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
    }
}

