/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.recipe.ShapelessRecipeTemplate;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ShapedRecipeTemplate
implements IRecipeTemplate<ShapedRecipeBuilder.Result> {
    private final List<Object> conditions = new ArrayList<Object>();
    public final Item result;
    public final int count;
    public final String group;
    public final List<String> pattern;
    public final Map<Character, Ingredient> keys;
    public final CraftingBookCategory category;

    public ShapedRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        ResourceLocation item = new ResourceLocation(result.get("item").getAsString());
        int count = 1;
        JsonElement c = result.get("count");
        if (c != null) {
            count = c.getAsInt();
        }
        this.result = (Item)BuiltInRegistries.f_257033_.m_7745_(item);
        this.count = count;
        this.category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
        JsonElement g = json.get("group");
        this.group = g == null ? "" : g.getAsString();
        ArrayList<String> patternList = new ArrayList<String>();
        JsonArray patterns = json.getAsJsonArray("pattern");
        patterns.forEach(p -> patternList.add(p.getAsString()));
        HashMap<Character, Ingredient> keyMap = new HashMap<Character, Ingredient>();
        JsonObject keys = json.getAsJsonObject("key");
        keys.entrySet().forEach(e -> keyMap.put(Character.valueOf(((String)e.getKey()).charAt(0)), Ingredient.m_43917_((JsonElement)((JsonElement)e.getValue()))));
        this.keys = keyMap;
        this.pattern = patternList;
    }

    @Override
    public <T extends BlockType> ShapedRecipeBuilder.Result createSimilar(T originalMat, T destinationMat, Item unlockItem, String id) {
        Item newRes = BlockType.changeItemType(this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s", this.result, originalMat, destinationMat));
        }
        ShapedRecipeBuilder builder = new ShapedRecipeBuilder(this.determineBookCategory(this.category), (ItemLike)newRes, this.count);
        boolean atLeastOneChanged = false;
        for (Map.Entry<Character, Ingredient> e : this.keys.entrySet()) {
            Ingredient ing = e.getValue();
            Ingredient newIng = IRecipeTemplate.convertIngredients(originalMat, destinationMat, ing);
            if (newIng != null) {
                atLeastOneChanged = true;
            } else {
                newIng = ing;
            }
            builder.m_126124_(e.getKey(), newIng);
        }
        if (!atLeastOneChanged) {
            return null;
        }
        this.pattern.forEach(arg_0 -> ((ShapedRecipeBuilder)builder).m_126130_(arg_0));
        builder.m_126145_(this.group);
        builder.m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{unlockItem}));
        AtomicReference newRecipe = new AtomicReference();
        if (id == null) {
            builder.m_176498_(r -> newRecipe.set((ShapedRecipeBuilder.Result)r));
        } else {
            builder.m_176500_(r -> newRecipe.set((ShapedRecipeBuilder.Result)r), id);
        }
        return (ShapedRecipeBuilder.Result)newRecipe.get();
    }

    @Override
    public List<Object> getConditions() {
        return this.conditions;
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    public boolean shouldBeShapeless() {
        return this.pattern.size() == 1 && this.pattern.get(0).length() == 1;
    }

    public ShapelessRecipeTemplate toShapeless() {
        return new ShapelessRecipeTemplate(this);
    }
}

