/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PassengerInformationScrollingTextSettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BERPassengerInfoSimple
implements AbstractAdvancedDisplayRenderer<PassengerInformationScrollingTextSettings> {
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyDate = "gui.createrailwaysnavigator.route_overview.date";
    private static final int TICKS_PER_SLIDE = 100;
    private TrainExitSide exitSide = TrainExitSide.UNKNOWN;
    private final BERLabel label = new BERLabel().setPos(3.0f, 5.5f).setYScale(0.75f).setScale(0.75f, 0.75f).setCentered(true).setScrollingSpeed(2.0f);

    @Override
    public void renderTick(float deltaTime) {
        this.label.renderTick();
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isEmpty()) {
            return;
        }
        float uv = 0.00390625f;
        TrainExitSide side = this.exitSide;
        if (backSide) {
            side = side.getOpposite();
        }
        switch (side) {
            case RIGHT: {
                BERUtils.renderTexture((ResourceLocation)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 3 - 8), (float)4.0f, (float)0.0f, (float)8.0f, (float)8.0f, (float)(uv * (float)ModGuiIcons.ARROW_RIGHT.getU()), (float)(uv * (float)ModGuiIcons.ARROW_RIGHT.getV()), (float)(uv * (float)(ModGuiIcons.ARROW_RIGHT.getU() + 16)), (float)(uv * (float)(ModGuiIcons.ARROW_RIGHT.getV() + 16)), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationScrollingTextSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                break;
            }
            case LEFT: {
                BERUtils.renderTexture((ResourceLocation)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)3.0f, (float)4.0f, (float)0.0f, (float)8.0f, (float)8.0f, (float)(uv * (float)ModGuiIcons.ARROW_LEFT.getU()), (float)(uv * (float)ModGuiIcons.ARROW_LEFT.getV()), (float)(uv * (float)(ModGuiIcons.ARROW_LEFT.getU() + 16)), (float)(uv * (float)(ModGuiIcons.ARROW_LEFT.getV() + 16)), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationScrollingTextSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                break;
            }
        }
        graphics.poseStack().m_85836_();
        switch (side) {
            case LEFT: {
                graphics.poseStack().m_252880_(10.0f, 0.0f, 0.0f);
                break;
            }
        }
        this.label.render(graphics, light);
        graphics.poseStack().m_85849_();
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason data) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().isEmpty()) {
            return;
        }
        PassengerInformationScrollingTextSettings settings = (PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity);
        TrainExitSide trainExitSide = settings.showExit() ? (blockEntity.getTrainData().isWaitingAtStation() ? this.exitSide : (TrainExitSide)((Object)blockEntity.relativeExitDirection.get())) : (this.exitSide = TrainExitSide.UNKNOWN);
        if (!blockEntity.getTrainData().getNextStop().isPresent()) {
            this.label.setText((Component)(settings.getTrainTextComponents().showTrainName() ? TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()) : TextUtils.empty()));
        } else if (blockEntity.getTrainData().isWaitingAtStation()) {
            this.label.setText((Component)TextUtils.text((String)blockEntity.getTrainData().getNextStop().get().getName()));
        } else if (blockEntity.getTrainData().getNextStop().get().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime() < (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue()) {
            this.label.setText((Component)CustomLanguage.translate(keyNextStop, blockEntity.getTrainData().getNextStop().get().getName()));
        } else {
            int slides = 3;
            int slide = (int)(DragonLib.getCurrentWorldTime() % 300L) / 100;
            if (slide == 1 && !settings.showTimeAndDate()) {
                ++slide;
            }
            if (slide == 2 && !settings.showStats()) {
                ++slide;
            }
            switch (slide %= 3) {
                case 0: {
                    this.label.setText((Component)TextUtils.text((String)((String)(settings.getTrainTextComponents().showTrainName() ? blockEntity.getTrainData().getTrainData().getName() + " " : "") + (settings.getTrainTextComponents().showDestination() ? blockEntity.getTrainData().getNextStop().get().getDestination() : ""))));
                    break;
                }
                case 1: {
                    this.label.setText((Component)CustomLanguage.translate(keyDate, blockEntity.m_58904_().m_46468_() / 24000L, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)));
                    break;
                }
                case 2: {
                    this.label.setText((Component)ModUtils.calcSpeedString(blockEntity.getTrainData().getSpeed(), (ESpeedUnit)((Object)ModClientConfig.SPEED_UNIT.get())));
                }
            }
            this.exitSide = TrainExitSide.UNKNOWN;
        }
        this.label.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6 - (this.exitSide == TrainExitSide.UNKNOWN ? 0 : 10)), BERLabel.BoundsHitReaction.SCROLL).setColor(0xFF000000 | ((PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
    }
}

