/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModDestinationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.SearchOptionButton;
import de.mrjulsen.crn.client.gui.widgets.StationDeparturesViewer;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutDepartureInWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutTrainGroupsWidget;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class ScheduleBoardScreen
extends AbstractNavigatorScreen {
    private StationDeparturesViewer viewer;
    private UserSettings userSettings;
    private DLEditBox stationBox;
    private String stationFrom;
    private ModDestinationSuggestions destinationSuggestions;
    private GuiAreaDefinition workingArea;
    private String stationTagName;
    private final boolean fixedStation;
    private final List<StationTag> stationNames;
    private final MutableComponent tooltipSearch;
    private final MutableComponent tooltipLocation;
    private final MutableComponent tooltipRefresh;

    public ScheduleBoardScreen(Screen lastScreen, StationTag.ClientStationTag tag) {
        super(lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.title"), CreateDynamicWidgets.BarColor.GOLD);
        this.userSettings = new UserSettings(Minecraft.m_91087_().f_91074_.m_20148_(), false);
        this.stationNames = new ArrayList<StationTag>();
        this.tooltipSearch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search.tooltip");
        this.tooltipLocation = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.location.tooltip");
        this.tooltipRefresh = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.refresh.tooltip");
        boolean bl = this.fixedStation = tag != null;
        if (this.fixedStation) {
            this.stationTagName = tag.tagName();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    public void m_86600_() {
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.stationBox.m_94204_()) {
                this.clearSuggestions();
            }
        });
        super.m_86600_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        DataAccessor.getFromServer((Object)true, ModAccessorTypes.GET_ALL_STATIONS_AS_TAGS, names -> {
            this.stationNames.clear();
            this.stationNames.addAll((Collection<StationTag>)names);
        });
        this.setAllowedLayer(0);
        int wY = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        int wH = 247 - wY - CreateDynamicWidgets.FooterSize.SMALL.size();
        this.workingArea = new GuiAreaDefinition(this.guiLeft + 3, this.guiTop + wY + 2, 234, wH - 3);
        if (!this.fixedStation) {
            this.stationBox = this.addEditBox(this.guiLeft + 32 + 5, this.guiTop + 25, 152, 12, this.stationFrom, (Component)TextUtils.empty(), false, v -> {
                this.stationFrom = v;
                this.updateEditorSubwidgets(this.stationBox);
            }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
            this.stationBox.m_94199_(32);
            DLCreateIconButton searchButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 190, this.guiTop + 20, 18, 18, (ScreenElement)AllIcons.I_MTD_SCAN){

                public void m_5716_(double mouseX, double mouseY) {
                    super.m_5716_(mouseX, mouseY);
                    if (ScheduleBoardScreen.this.stationFrom == null || ScheduleBoardScreen.this.stationFrom.isBlank()) {
                        ScheduleBoardScreen.this.viewer.displayRoutes(null, ScheduleBoardScreen.this.userSettings);
                        return;
                    }
                    DataAccessor.getFromServer((Object)TagName.of(ScheduleBoardScreen.this.stationFrom), ModAccessorTypes.GET_STATION_TAG_BY_TAG_NAME, result -> {
                        ScheduleBoardScreen.this.stationTagName = result.getTagName().get();
                        ScheduleBoardScreen.this.viewer.displayRoutes(ScheduleBoardScreen.this.stationTagName, ScheduleBoardScreen.this.userSettings);
                    });
                }
            });
            this.addTooltip(DLTooltip.of((FormattedText)this.tooltipSearch).assignedTo((AbstractWidget)searchButton));
            DLCreateIconButton locationButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 212, this.guiTop + 20, 18, 18, (ScreenElement)ModGuiIcons.POSITION.getAsCreateIcon()){

                public void m_5716_(double mouseX, double mouseY) {
                    super.m_5716_(mouseX, mouseY);
                    DataAccessor.getFromServer((Object)((ScheduleBoardScreen)ScheduleBoardScreen.this).f_96541_.f_91074_.m_20183_(), ModAccessorTypes.GET_NEAREST_STATION, result -> {
                        if (result.tagName.isPresent()) {
                            ScheduleBoardScreen.this.stationBox.m_94144_(result.tagName.get().get());
                        }
                    });
                }
            });
            this.addTooltip(DLTooltip.of((FormattedText)this.tooltipLocation).assignedTo((AbstractWidget)locationButton));
        }
        int btnCount = 2;
        int btnWidth = (this.workingArea.getWidth() - 16) / 2;
        this.m_142416_((GuiEventListener)new SearchOptionButton(this.workingArea.getLeft(), this.workingArea.getTop() + 16 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.departure_in"), () -> this.userSettings.searchDepartureInTicks.toString(), b -> new FlyoutDepartureInWidget<GuiEventListener>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> this.m_142416_((GuiEventListener)x$0), this.userSettings, () -> this.userSettings.searchDepartureInTicks, w -> {
            this.m_169411_((GuiEventListener)w);
            this.reloadUserSettings(() -> this.viewer.displayRoutes(this.stationTagName, this.userSettings));
        }).open((IDragonLibWidget)b)));
        this.m_142416_((GuiEventListener)new SearchOptionButton(this.workingArea.getLeft() + btnWidth, this.workingArea.getTop() + 16 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups"), () -> this.userSettings.searchExcludedTrainGroups.toString(), b -> new FlyoutTrainGroupsWidget<GuiEventListener>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> this.m_142416_((GuiEventListener)x$0), this.userSettings, () -> this.userSettings.searchExcludedTrainGroups, w -> {
            this.m_169411_((GuiEventListener)w);
            this.reloadUserSettings(() -> this.viewer.displayRoutes(this.stationTagName, this.userSettings));
        }).open((IDragonLibWidget)b)));
        DLIconButton refreshBtn = (DLIconButton)this.m_142416_((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.REFRESH.getAsSprite(16, 16), this.workingArea.getRight() - (this.workingArea.getWidth() - btnWidth * 2), this.workingArea.getTop() + 16 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, this.workingArea.getWidth() - btnWidth * 2, 18, (Component)TextUtils.empty(), b -> this.reloadUserSettings(() -> this.viewer.displayRoutes(this.stationTagName, this.userSettings))));
        refreshBtn.setBackColor(0);
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipRefresh).assignedTo((AbstractWidget)refreshBtn));
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, this.workingArea.getRight() - 5, this.workingArea.getY() + 50, this.workingArea.getHeight() - 50, GuiAreaDefinition.of((Screen)this.lastScreen));
        this.viewer = new StationDeparturesViewer((Screen)this, this.workingArea.getX(), this.workingArea.getY() + 50, this.workingArea.getWidth(), this.workingArea.getHeight() - 50, (DLAbstractScrollBar<?>)scrollBar);
        this.m_142416_((GuiEventListener)this.viewer);
        this.m_142416_((GuiEventListener)scrollBar);
        this.reloadUserSettings(() -> this.viewer.displayRoutes(this.stationTagName, this.userSettings));
    }

    private void reloadUserSettings(Runnable andThen) {
        DataAccessor.getFromServer((Object)Minecraft.m_91087_().f_91074_.m_20148_(), ModAccessorTypes.GET_USER_SETTINGS, settings -> {
            this.userSettings = settings;
            DLUtils.doIfNotNull((Object)andThen, Runnable::run);
        });
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderNavigatorBackground(graphics, mouseX, mouseY, partialTicks);
        CreateDynamicWidgets.renderContainer(graphics, this.workingArea.getX() - 2, this.workingArea.getY() - 2, this.workingArea.getWidth() + 4, 30, CreateDynamicWidgets.ContainerColor.BLUE);
        CreateDynamicWidgets.renderContainer(graphics, this.workingArea.getX() - 2, this.workingArea.getY() - 2 + 29, this.workingArea.getWidth() + 4, 22, CreateDynamicWidgets.ContainerColor.GOLD);
        CreateDynamicWidgets.renderContainer(graphics, this.workingArea.getX() - 2, this.workingArea.getY() - 2 + 50, this.workingArea.getWidth() + 4, this.workingArea.getHeight() + 4 - 50, CreateDynamicWidgets.ContainerColor.PURPLE);
        if (this.fixedStation) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(2.0f, 2.0f, 2.0f);
            GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)((this.guiLeft + 120) / 2), (int)((this.guiTop + 22) / 2), (FormattedText)GuiUtils.ellipsisString((Font)this.f_96547_, (Component)TextUtils.text((String)this.stationTagName), (int)120), (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            graphics.poseStack().m_85849_();
        } else {
            ModGuiIcons.POSITION.render(graphics, this.workingArea.getX() + 5, this.workingArea.getY() + 4);
            CreateDynamicWidgets.renderTextBox(graphics, this.guiLeft + 32, this.guiTop + 20, 154);
        }
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.destinationSuggestions != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_(0.0f, 0.0f, 500.0f);
            this.destinationSuggestions.render(graphics.graphics(), mouseX, mouseY);
            graphics.poseStack().m_85849_();
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        this.updateEditorSubwidgetsInternal(field, this.getViableStations(this.stationNames));
    }

    protected void updateEditorSubwidgetsInternal(DLEditBox field, List<StationTag> list) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModDestinationSuggestions(this.f_96541_, (Screen)this, (EditBox)field, this.f_96547_, list, field.m_93694_() + 2 + field.y());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<StationTag> getViableStations(Collection<StationTag> src) {
        return src.stream().distinct().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList();
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().m_94167_("");
        }
        this.destinationSuggestions = null;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(pMouseX, pMouseY, Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }
}

