/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.Lang;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.DLCreateScrollInput;
import de.mrjulsen.crn.client.gui.widgets.DLCreateSelectionScrollInput;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetContainer;
import de.mrjulsen.crn.data.train.StationDepartureHistory;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TrainSeparationSettingsScreen
extends DLScreen {
    private static final MutableComponent title = TextUtils.translate((String)"createrailwaysnavigator.schedule.condition.train_separation.settings");
    private static final int GUI_WIDTH = 212;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.SMALL;
    private static final int LINES = 2;
    private static final int GUI_HEIGHT = headerSize.size() + footerSize.size() + 44 + 12;
    private int guiLeft;
    private int guiTop;
    private GuiAreaDefinition workingArea;
    private DLCreateIconButton backButton;
    private ModularWidgetContainer commonSettingsContainer;
    private final Screen lastScreen;
    private final CompoundTag nbt;
    private int minutes = 0;
    private int seconds = 5;
    private int ticks = 0;
    private StationDepartureHistory.ETrainFilter filter = StationDepartureHistory.ETrainFilter.ANY;

    public TrainSeparationSettingsScreen(Screen lastScreen, CompoundTag nbt) {
        super((Component)title);
        int t;
        this.lastScreen = lastScreen;
        this.nbt = nbt;
        this.ticks = t = nbt.m_128441_("Ticks") ? nbt.m_128451_("Ticks") : nbt.m_128451_("Value") * TimedWaitCondition.TimeUnit.values()[nbt.m_128451_((String)"TimeUnit")].ticksPer;
        this.minutes = this.ticks / 1200;
        this.ticks %= 1200;
        this.seconds = this.ticks / 20;
        this.ticks %= 20;
        this.filter = StationDepartureHistory.ETrainFilter.getByIndex(nbt.m_128445_("TrainFilter"));
    }

    public void m_7379_() {
        super.m_7379_();
        this.nbt.m_128405_("Ticks", this.minutes * TimedWaitCondition.TimeUnit.MINUTES.ticksPer + this.seconds * TimedWaitCondition.TimeUnit.SECONDS.ticksPer + this.ticks);
        this.nbt.m_128344_("TrainFilter", this.filter.getIndex());
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 106;
        this.guiTop = this.f_96544_ / 2 - GUI_HEIGHT / 2;
        this.workingArea = new GuiAreaDefinition(this.guiLeft + 1, this.guiTop + headerSize.size(), 210, GUI_HEIGHT - headerSize.size() - footerSize.size());
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, 0, 0, 0, GuiAreaDefinition.empty());
        this.commonSettingsContainer = (ModularWidgetContainer)this.m_142416_((GuiEventListener)new ModularWidgetContainer(this, this.workingArea.getX() + 2, this.workingArea.getY() + 1, this.workingArea.getWidth() - 4, 54, (w, builder) -> {
            builder.addLine("times", line -> {
                line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.TIME.getAsSprite(16, 16)));
                line.add(new DLCreateScrollInput(this, line.getCurrentX() + 6, line.getY() + 2, 30, 18).setRenderArrow(true).titled(Lang.translateDirect((String)"generic.unit.minutes", (Object[])new Object[0])).withShiftStep(10).withRange(0, 901).setState(this.minutes).calling(x -> {
                    this.minutes = x;
                }));
                line.add(new DLCreateScrollInput(this, line.getCurrentX() + 2, line.getY() + 2, 30, 18).titled(Lang.translateDirect((String)"generic.unit.seconds", (Object[])new Object[0])).withShiftStep(10).withRange(0, 60).setState(this.seconds).calling(x -> {
                    this.seconds = x;
                }));
                line.add(new DLCreateScrollInput(this, line.getCurrentX() + 2, line.getY() + 2, 30, 18).titled(Lang.translateDirect((String)"generic.unit.ticks", (Object[])new Object[0])).withShiftStep(5).withRange(0, 20).setState(this.ticks).calling(x -> {
                    this.ticks = x;
                }));
            });
            builder.addLine("train_filter", line -> {
                line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.TRAIN.getAsSprite(16, 16)));
                line.add(new DLCreateSelectionScrollInput(this, line.getCurrentX() + 6, line.getY() + 2, line.getRemainingWidth() - 6, 18).setRenderArrow(true).forOptions(Arrays.stream(StationDepartureHistory.ETrainFilter.values()).map(x -> TextUtils.translate((String)x.getValueTranslationKey("createrailwaysnavigator"))).toList()).setState((int)this.filter.getIndex()).titled(TextUtils.translate((String)StationDepartureHistory.ETrainFilter.ANY.getEnumTranslationKey("createrailwaysnavigator"))).addHint(TextUtils.translate((String)StationDepartureHistory.ETrainFilter.ANY.getEnumDescriptionTranslationKey("createrailwaysnavigator"))).setState((int)this.filter.getIndex()).calling(i -> {
                    this.filter = StationDepartureHistory.ETrainFilter.getByIndex(i);
                }));
            });
        }, (DLAbstractScrollBar<?>)scrollBar, 18, 18, 4, 4));
        this.m_142416_((GuiEventListener)scrollBar);
        this.backButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 212 - 7 - 18, this.guiTop + GUI_HEIGHT - 6 - 18, 18, 18, (ScreenElement)AllIcons.I_CONFIRM));
        this.backButton.withCallback(() -> this.m_7379_());
        DLCreateIconButton helpButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 212 - 17 - 36, this.guiTop + GUI_HEIGHT - 6 - 18, 18, 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Separation");
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TEXT_HELP).assignedTo((AbstractWidget)helpButton));
    }

    public boolean m_7043_() {
        return false;
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderScreenBackground(graphics);
        CreateDynamicWidgets.renderWindow(graphics, this.guiLeft, this.guiTop, 212, GUI_HEIGHT, CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), false);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, this.guiLeft + 212 - 31, this.guiTop + GUI_HEIGHT - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        int commonHeight = this.commonSettingsContainer.getHeight() + 4;
        CreateDynamicWidgets.renderContainer(graphics, this.workingArea.getX(), this.workingArea.getY() - 1, this.workingArea.getWidth(), commonHeight, CreateDynamicWidgets.ContainerColor.PURPLE);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 6), (int)(this.guiTop + 4), (FormattedText)title, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }
}

