/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;

public class CRNListBox<T, W extends DLButton>
extends DLScrollableWidgetContainer {
    private final Screen parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;
    private final Map<W, T> values = new HashMap<W, T>();

    public CRNListBox(Screen parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public Screen getParent() {
        return this.parent;
    }

    public void displayData(List<T> data, BiFunction<T, Integer, W> createItem) {
        this.clearWidgets();
        this.values.clear();
        this.contentHeight = 0;
        for (int i = 0; i < data.size(); ++i) {
            T entry = data.get(i);
            DLButton widget = (DLButton)createItem.apply(entry, i);
            if (widget == null) continue;
            widget.set_x(this.x());
            widget.set_width(this.width());
            widget.set_y(this.y() + this.contentHeight);
            this.addRenderableWidget((GuiEventListener)widget);
            this.values.put(widget, entry);
            this.contentHeight += widget.height();
        }
        this.scrollBar.setMaxScroll(this.contentHeight);
    }

    public Set<Map.Entry<W, T>> getEntries() {
        return this.values.entrySet();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollBar.getScrollValue() > 0.0) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        }
        if (this.scrollBar.getScrollValue() < (double)this.scrollBar.getMaxScroll()) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

