/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.event;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.event.CRNClientEventsRegistryEvent;
import de.mrjulsen.crn.event.CRNCommonEventsRegistryEvent;
import de.mrjulsen.crn.event.IEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class CRNEventsManager {
    protected static final Map<Class<? extends AbstractCRNEvent>, AbstractCRNEvent<?>> registeredEvents = new HashMap();

    public static <T extends AbstractCRNEvent<?>> T getEvent(Class<T> clazz) {
        if (registeredEvents.containsKey(clazz)) {
            return (T)registeredEvents.get(clazz);
        }
        throw new NullPointerException("The Event " + clazz.getName() + " is not registered!");
    }

    public static <T extends AbstractCRNEvent<?>> Optional<T> getEventOptional(Class<T> clazz) {
        if (registeredEvents.containsKey(clazz)) {
            return Optional.ofNullable(registeredEvents.get(clazz));
        }
        return Optional.empty();
    }

    public static void registerEvent(Supplier<AbstractCRNEvent<?>> eventInstance) {
        CRNEventsManager.registerEvent(eventInstance.get());
    }

    public static void registerEvent(AbstractCRNEvent<?> eventInstance) {
        if (eventInstance instanceof AbstractBuiltInCRNEvent) {
            throw new IllegalArgumentException("Cannot register CRN System events!");
        }
        CRNEventsManager.registerEventInternal(eventInstance);
    }

    static void registerEventInternal(AbstractCRNEvent<?> eventInstance) {
        registeredEvents.put(eventInstance.getClass(), eventInstance);
    }

    public static void clearEvents() {
        registeredEvents.values().removeIf(x -> !(x instanceof AbstractBuiltInCRNEvent));
        CreateRailwaysNavigator.LOGGER.info("All events have been closed.");
    }

    public static <T extends AbstractCRNEvent<?>> boolean isRegistered(Class<T> clazz) {
        return registeredEvents.containsKey(clazz);
    }

    static {
        CRNEventsManager.registerEventInternal(new CRNClientEventsRegistryEvent());
        CRNEventsManager.registerEventInternal(new CRNCommonEventsRegistryEvent());
    }

    public static abstract class AbstractCRNEvent<T>
    implements IEvent<T> {
        protected final Map<String, T> listeners = new HashMap<String, T>();
        protected final Set<String> idsToRemove = new HashSet<String>();

        @Override
        public void register(String modid, T event) {
            this.listeners.put(modid, event);
        }

        @Override
        public void unregister(String modid) {
            if (this.listeners.containsKey(modid)) {
                this.idsToRemove.add(modid);
            }
        }

        public void tickPost() {
            this.listeners.keySet().removeAll(this.idsToRemove);
            this.idsToRemove.clear();
        }
    }

    static abstract class AbstractBuiltInCRNEvent<T>
    extends AbstractCRNEvent<T> {
        AbstractBuiltInCRNEvent() {
        }
    }
}

