/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.mixin;

import com.simibubi.create.content.trains.entity.Navigation;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.condition.IDelayedWaitCondition;
import de.mrjulsen.mcdragonlib.data.Pair;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Navigation.class})
public abstract class NavigationMixin
implements INavigationExtension {
    public Queue<Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>> delayedWaitConditions = new ConcurrentLinkedQueue<Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>>();

    @Override
    public void addDelayedWaitCondition(Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext> pair) {
        this.delayedWaitConditions.add(pair);
    }

    @Override
    public boolean isDelayedWaitConditionPending() {
        return !this.delayedWaitConditions.isEmpty();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;leaveStation()V", shift=At.Shift.BEFORE)}, remap=false, cancellable=true)
    public void onTick(Level level, CallbackInfo ci) {
        if (!this.delayedWaitConditions.isEmpty()) {
            Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext> p = this.delayedWaitConditions.peek();
            if (!((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128441_("Delay")) {
                ((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128405_("Delay", 0);
            }
            if (((IDelayedWaitCondition)p.getFirst()).runDelayed((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond())) {
                ((IDelayedWaitCondition.DelayedWaitConditionContext)this.delayedWaitConditions.poll().getSecond()).nbt().m_128473_("Delay");
            } else {
                ((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128405_("Delay", ((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128451_("Delay") + 1);
            }
            ci.cancel();
        }
    }

    @Inject(method={"cancelNavigation"}, at={@At(value="HEAD")}, remap=false)
    public void resetOnCancel(CallbackInfo ci) {
        this.delayedWaitConditions.clear();
    }
}

