/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.mixin;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.data.train.StationDepartureHistory;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={StationBlockEntity.class})
public class StationBlockEntityMixin
implements IHaveGoggleInformation {
    private StationDepartureHistory.StationStats stats;

    private StationBlockEntity self() {
        return (StationBlockEntity)this;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        List<Map.Entry<String, Long>> data;
        if (CRNPlatformSpecific.getStationFromBlockEntity((BlockEntity)this.self()) == null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91073_.m_46467_() % 100L == 0L) {
            DataAccessor.getFromServer((Object)CRNPlatformSpecific.getStationFromBlockEntity((BlockEntity)this.self()).name, ModAccessorTypes.GET_STATION_DEPARTURE_HISTORY, x -> {
                this.stats = x;
            });
        }
        Lang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.title")).forGoggles(tooltip);
        if (this.stats == null || this.stats.isEmpty()) {
            Lang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.nothing").m_130940_(ChatFormatting.RED)).forGoggles(tooltip);
            return false;
        }
        Lang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.any").m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
        Lang.builder((String)"createrailwaysnavigator").add(this.formatTime(Minecraft.m_91087_().f_91073_.m_46467_() - this.stats.getLastDepartureTime())).forGoggles(tooltip, 1);
        if (this.stats.hasDeparturesByLine()) {
            Lang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.line").m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
            data = this.stats.getDeparturesByLine();
            for (Map.Entry<String, Long> d : data) {
                Lang.builder((String)"createrailwaysnavigator").add(TextUtils.empty().m_7220_((Component)TextUtils.text((String)(d.getKey() + ": ")).m_130940_(ChatFormatting.DARK_AQUA)).m_7220_((Component)this.formatTime(Minecraft.m_91087_().f_91073_.m_46467_() - d.getValue()))).forGoggles(tooltip, 1);
            }
            if (this.stats.getDeparturesByLineTotalCount() > data.size()) {
                Lang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.has_more", (Object[])new Object[]{this.stats.getDeparturesByLineTotalCount() - data.size()}).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
            }
        }
        if (this.stats.hasDeparturesByGroup()) {
            Lang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.group").m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
            data = this.stats.getDeparturesByGroup();
            for (Map.Entry<String, Long> d : data) {
                Lang.builder((String)"createrailwaysnavigator").add(TextUtils.empty().m_7220_((Component)TextUtils.text((String)(d.getKey() + ": ")).m_130940_(ChatFormatting.DARK_AQUA)).m_7220_((Component)this.formatTime(Minecraft.m_91087_().f_91073_.m_46467_() - d.getValue()))).forGoggles(tooltip, 1);
            }
            if (this.stats.getDeparturesByGroupTotalCount() > data.size()) {
                Lang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.has_more", (Object[])new Object[]{this.stats.getDeparturesByGroupTotalCount() - data.size()}).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
            }
        }
        return true;
    }

    private MutableComponent formatTime(long ticks) {
        return TextUtils.text((String)TimeUtils.formatDurationMs((long)TimeUnit.SECONDS.toMillis((long)((double)ticks / DragonLib.mcTps())))).m_130940_(ChatFormatting.AQUA);
    }
}

