/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.PostBoxBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PostBoxBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    public PostBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
        VoxelShape standShape = Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
        VoxelShape topShape = Block.m_49796_((double)2.0, (double)9.0, (double)1.0, (double)14.0, (double)22.0, (double)15.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> VoxelShapeHelper.combine(List.of(baseShape, standShape, VoxelShapeHelper.rotateHorizontally(topShape, (Direction)state.m_61143_((Property)DIRECTION)))))));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof PostBoxBlockEntity) {
            PostBoxBlockEntity postBox = (PostBoxBlockEntity)blockEntity;
            FrameworkAPI.openMenuWithData((ServerPlayer)((ServerPlayer)player), (MenuProvider)postBox, buf -> DeliveryService.get(((ServerLevel)level).m_7654_()).ifPresent(service -> service.encodeMailboxes((FriendlyByteBuf)buf)));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PostBoxBlockEntity(pos, state);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_, BlockTags.f_144286_);
    }
}

