/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    private final DyeColor color;

    public SofaBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
    }

    public DyeColor getDyeColor() {
        return this.color;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape frontLeftLegShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
        VoxelShape frontRightLegShape = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
        VoxelShape backLeftLegShape = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
        VoxelShape backRightLegShape = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape leftArmShape = Block.m_49796_((double)0.0, (double)6.0, (double)-2.0, (double)16.0, (double)14.0, (double)2.0);
        VoxelShape rightArmShape = Block.m_49796_((double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)14.0, (double)18.0);
        VoxelShape backRestShape = Block.m_49796_((double)12.0, (double)10.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(baseShape);
            shapes.add(backRestShape);
            switch ((Shape)((Object)((Object)state.m_61143_(SHAPE)))) {
                case DEFAULT: {
                    shapes.add(frontLeftLegShape);
                    shapes.add(frontRightLegShape);
                    shapes.add(backLeftLegShape);
                    shapes.add(backRightLegShape);
                    shapes.add(leftArmShape);
                    shapes.add(rightArmShape);
                    break;
                }
                case LEFT: {
                    shapes.add(frontLeftLegShape);
                    shapes.add(backLeftLegShape);
                    shapes.add(leftArmShape);
                    break;
                }
                case RIGHT: {
                    shapes.add(frontRightLegShape);
                    shapes.add(backRightLegShape);
                    shapes.add(rightArmShape);
                    break;
                }
                case CORNER_LEFT: {
                    shapes.add(backLeftLegShape);
                    shapes.add(VoxelShapeHelper.rotateHorizontally(backRestShape, Direction.NORTH));
                    break;
                }
                case CORNER_RIGHT: {
                    shapes.add(backRightLegShape);
                    shapes.add(VoxelShapeHelper.rotateHorizontally(backRestShape, Direction.SOUTH));
                }
            }
            return VoxelShapeHelper.rotateHorizontally(VoxelShapeHelper.combine(shapes), (Direction)state.m_61143_((Property)DIRECTION));
        })));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, (LevelAccessor)context.m_43725_(), context.m_8083_())));
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (Seat.sit(player, pos, 0.375, ((Direction)state.m_61143_((Property)DIRECTION)).m_122424_())) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, level, pos)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHAPE});
    }

    public Shape getShape(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)DIRECTION);
        Direction front = this.getSofaDirection(level, pos, facing.m_122424_());
        if (front != null) {
            if (front == facing.m_122427_()) {
                return Shape.CORNER_RIGHT;
            }
            if (front == facing.m_122428_()) {
                return Shape.CORNER_LEFT;
            }
        }
        boolean left = this.isConnectable(level, pos, facing, facing.m_122428_());
        boolean right = this.isConnectable(level, pos, facing, facing.m_122427_());
        if (left && right) {
            return Shape.MIDDLE;
        }
        if (left) {
            return Shape.RIGHT;
        }
        if (right) {
            return Shape.LEFT;
        }
        return Shape.DEFAULT;
    }

    private Direction getSofaDirection(LevelAccessor level, BlockPos pos, Direction side) {
        BlockState relativeState = level.m_8055_(pos.m_121945_(side));
        return relativeState.m_60734_() instanceof SofaBlock ? (Direction)relativeState.m_61143_((Property)DIRECTION) : null;
    }

    private boolean isConnectable(LevelAccessor level, BlockPos pos, Direction facing, Direction offset) {
        BlockPos relativePos = pos.m_121945_(offset);
        BlockState relativeState = level.m_8055_(pos.m_121945_(offset));
        if (relativeState.m_60734_() instanceof SofaBlock) {
            Direction other = (Direction)relativeState.m_61143_((Property)DIRECTION);
            return other == facing || other == offset;
        }
        return relativeState.m_60783_((BlockGetter)level, relativePos, offset.m_122424_());
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144280_);
    }

    public static enum Shape implements StringRepresentable
    {
        DEFAULT("default"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

