/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ToolboxHandler.class}, remap=false)
public abstract class MixinToolboxHandler {
    @Shadow
    public static void syncData(Player player) {
        throw new AssertionError();
    }

    @Inject(method={"onLoad", "onUnload"}, at={@At(value="HEAD")}, cancellable=true)
    private static void railways$keepMountedToolboxesOutOfMap(ToolboxBlockEntity be, CallbackInfo ci) {
        if (be instanceof MountedToolbox) {
            ci.cancel();
        }
    }

    @Inject(method={"entityTick"}, remap=false, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isLoaded(Lnet/minecraft/core/BlockPos;)Z", remap=true)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void railways$connectConductorToolboxes(Entity entity, Level world, CallbackInfo ci, ServerPlayer player, boolean sendData, CompoundTag compound, int i, String key, CompoundTag data, BlockPos pos, int slot) {
        if (!data.m_128403_("EntityUUID") || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        UUID uuid = data.m_128342_("EntityUUID");
        Entity toolboxHolder = level.m_8791_(uuid);
        if (toolboxHolder instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)toolboxHolder;
            MountedToolbox toolbox = conductor.getToolbox();
            if (toolbox != null) {
                toolbox.connectPlayer(slot, (Player)player, i);
            }
        } else {
            compound.m_128473_(key);
            MixinToolboxHandler.syncData((Player)player);
        }
    }

    @ModifyVariable(method={"unequip"}, remap=false, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", remap=true))
    private static BlockEntity railways$getConductorToolbox(BlockEntity be, Player player, int hotbarSlot, boolean keepItems) {
        ConductorEntity conductor;
        Level level = player.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return be;
        }
        ServerLevel level2 = (ServerLevel)level;
        CompoundTag toolboxData = EntityUtils.getPersistentData((Entity)player).m_128469_("CreateToolboxData");
        String key = String.valueOf(hotbarSlot);
        CompoundTag data = toolboxData.m_128469_(key);
        if (!data.m_128403_("EntityUUID")) {
            return be;
        }
        UUID uuid = data.m_128342_("EntityUUID");
        Entity entity = level2.m_8791_(uuid);
        if (!(entity instanceof ConductorEntity) || !(conductor = (ConductorEntity)entity).isCarryingToolbox()) {
            return be;
        }
        return conductor.getToolbox();
    }

    @Inject(method={"getNearest"}, at={@At(value="RETURN")})
    private static void railways$findNearbyConductors(LevelAccessor world, Player player, int maxAmount, CallbackInfoReturnable<List<ToolboxBlockEntity>> cir) {
        List toolboxes = (List)cir.getReturnValue();
        Set conductors = (Set)ConductorEntity.WITH_TOOLBOXES.get(world);
        if (conductors.isEmpty()) {
            return;
        }
        Vec3 playerPos = player.m_20182_();
        double maxRangeSqr = Math.pow(ToolboxHandler.getMaxRange((Player)player), 2.0);
        for (ConductorEntity conductor : conductors) {
            if (!(ToolboxHandler.distance((Vec3)playerPos, (BlockPos)conductor.m_20183_()) < maxRangeSqr)) continue;
            toolboxes.add(conductor.getToolbox());
        }
        toolboxes.sort((be1, be2) -> {
            double d1 = ToolboxHandler.distance((Vec3)playerPos, (BlockPos)be1.m_58899_());
            double d2 = ToolboxHandler.distance((Vec3)playerPos, (BlockPos)be2.m_58899_());
            return Double.compare(d1, d2);
        });
    }
}

