/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.handcar.HandcarItem;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.mutable.MutableObject;

public class CurvedTrackHandcarPlacementPacket
implements C2SPacket {
    private final BlockPos pos;
    private final BlockPos targetPos;
    private final boolean front;
    private final int segment;
    private final int slot;

    public CurvedTrackHandcarPlacementPacket(BlockPos pos, BlockPos targetPos, int segment, boolean front, int slot) {
        this.pos = pos;
        this.targetPos = targetPos;
        this.segment = segment;
        this.front = front;
        this.slot = slot;
    }

    public CurvedTrackHandcarPlacementPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.targetPos = buf.m_130135_();
        this.segment = buf.m_130242_();
        this.front = buf.readBoolean();
        this.slot = buf.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130064_(this.targetPos);
        buffer.m_130130_(this.segment);
        buffer.writeBoolean(this.front);
        buffer.m_130130_(this.slot);
    }

    protected void actuallyHandle(ServerPlayer player, TrackBlockEntity be) {
        if (player.m_150109_().f_35977_ != this.slot) {
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(this.slot);
        Item item = stack.m_41720_();
        if (!(item instanceof HandcarItem)) {
            return;
        }
        HandcarItem handcarItem = (HandcarItem)item;
        MutableObject result = new MutableObject(null);
        MutableObject resultLoc = new MutableObject(null);
        HandcarItem.withGraphLocation(player.f_19853_, this.pos, this.front, new BezierTrackPointLocation(this.targetPos, this.segment), (overlap, location) -> {
            result.setValue(overlap);
            resultLoc.setValue(location);
        });
        BezierConnection bc = (BezierConnection)be.getConnections().get(this.targetPos);
        TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
        if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return;
        }
        if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
            player.m_5661_((Component)Lang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).m_130940_(ChatFormatting.RED), true);
            AllSoundEvents.DENY.play(player.f_19853_, null, (Vec3i)this.pos, 0.5f, 1.0f);
            return;
        }
        TrackGraphLocation loc = (TrackGraphLocation)resultLoc.getValue();
        if (loc == null) {
            return;
        }
        if (handcarItem.placeHandcar(loc, player.f_19853_, (Player)player, this.pos) && !player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    @Override
    public void handle(ServerPlayer sender) {
        Level world = sender.f_19853_;
        if (world == null || !world.m_46749_(this.pos)) {
            return;
        }
        if (!this.pos.m_123314_((Vec3i)sender.m_20183_(), 64.0)) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(this.pos);
        if (blockEntity instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
            this.actuallyHandle(sender, tbe);
        }
    }
}

