/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class PlaceableBookManager {
    private static final Map<String, BookType> BY_NAME = new HashMap<String, BookType>();
    private static final Multimap<Item, BookType> BY_ITEM = HashMultimap.create();

    public static void register(BookType type, @Nullable Item item) {
        if (item != null) {
            BY_ITEM.put((Object)item, (Object)type);
            BY_NAME.put(type.name(), type);
        }
    }

    public static void registerDefault(DyeColor color) {
        PlaceableBookManager.register(new BookType(color), Items.f_42517_);
    }

    public static void registerDefault(DyeColor color, int angle) {
        PlaceableBookManager.register(new BookType(color, (float)angle, false), Items.f_42517_);
    }

    public static void registerDefault(String name, int color) {
        PlaceableBookManager.register(new BookType(name, color, false), Items.f_42517_);
    }

    public static void setup() {
        PlaceableBookManager.registerDefault(DyeColor.BROWN, 1);
        PlaceableBookManager.registerDefault(DyeColor.WHITE, 1);
        PlaceableBookManager.registerDefault(DyeColor.BLACK, 1);
        PlaceableBookManager.registerDefault(DyeColor.LIGHT_GRAY);
        PlaceableBookManager.registerDefault(DyeColor.GRAY);
        PlaceableBookManager.registerDefault(DyeColor.ORANGE);
        PlaceableBookManager.registerDefault(DyeColor.YELLOW);
        PlaceableBookManager.registerDefault(DyeColor.LIME);
        PlaceableBookManager.registerDefault("green", 3129655);
        PlaceableBookManager.registerDefault("cyan", 1502399);
        PlaceableBookManager.registerDefault(DyeColor.LIGHT_BLUE);
        PlaceableBookManager.registerDefault(DyeColor.BLUE);
        PlaceableBookManager.registerDefault(DyeColor.PURPLE);
        PlaceableBookManager.registerDefault(DyeColor.MAGENTA);
        PlaceableBookManager.registerDefault(DyeColor.PINK);
        PlaceableBookManager.registerDefault(DyeColor.RED);
        PlaceableBookManager.register(new BookType("enchanted", 0, 1.0f, true), Items.f_42690_);
        PlaceableBookManager.register(new BookType("and_quill", 0, 1.0f, false), Items.f_42614_);
        PlaceableBookManager.register(new BookType("written", 0, 1.0f, false), Items.f_42615_);
        PlaceableBookManager.register(new BookType("tattered", 0, 1.0f, false), null);
        PlaceableBookManager.register(new BookType("tome", 0, 1.0f, true), CompatObjects.TOME.get());
        PlaceableBookManager.register(new BookType("gene", 0, 1.0f, false), CompatObjects.GENE_BOOK.get());
    }

    public static BookType rand(Random r) {
        ArrayList<BookType> all = PlaceableBookManager.getAll();
        return all.get(r.nextInt(all.size()));
    }

    public static ArrayList<BookType> getAll() {
        return new ArrayList<BookType>(BY_ITEM.values());
    }

    public static BookType getByName(String name) {
        BookType b = BY_NAME.get(name);
        if (b == null) {
            return BY_NAME.get("brown");
        }
        return b;
    }

    public static ArrayList<BookType> getByItem(ItemStack stack) {
        if (AntiqueInkItem.hasAntiqueInk(stack)) {
            return new ArrayList<BookType>(List.of(PlaceableBookManager.getByName("tattered")));
        }
        Item item = stack.m_41720_();
        if (Utils.getID((Item)item).m_135827_().equals("inspirations")) {
            String colName = Utils.getID((Item)item).m_135815_().replace("_book", "");
            return new ArrayList<BookType>(List.of(PlaceableBookManager.getByName(colName)));
        }
        return new ArrayList<BookType>(BY_ITEM.get((Object)item));
    }
}

