/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.Nullable;

public class ShowWaresGoal
extends LookAtPlayerGoal {
    protected final AbstractVillager villager;
    private Player player;
    private final int minDuration;
    private final int maxDuration;
    private final List<ItemStack> displayItems = Lists.newArrayList();
    @Nullable
    private ItemStack playerItemStack;
    private int cycleCounter;
    private int displayIndex;
    private int lookTime;

    public ShowWaresGoal(AbstractVillager mob, int minDuration, int maxDuration) {
        super((Mob)mob, Player.class, 8.0f);
        this.villager = mob;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
    }

    public boolean m_8036_() {
        if (!this.villager.m_35306_()) {
            return super.m_8036_();
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.f_25513_.m_6084_()) {
            return false;
        }
        if (this.villager.m_35306_()) {
            return false;
        }
        if (this.f_25512_.m_20280_(this.f_25513_) > (double)(this.f_25514_ * this.f_25514_)) {
            return false;
        }
        return this.lookTime > 0;
    }

    public void m_8056_() {
        this.lookTime = 40;
        this.cycleCounter = 0;
        this.displayIndex = 0;
        this.player = (Player)this.f_25513_;
    }

    public void m_8037_() {
        this.findItemsToDisplay();
        if (!this.displayItems.isEmpty()) {
            this.displayCyclingItems();
        } else {
            this.villager.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        --this.lookTime;
        super.m_8037_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.villager.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.playerItemStack = null;
    }

    private void findItemsToDisplay() {
        boolean flag = false;
        ItemStack handStack = this.player.m_21205_();
        if (this.playerItemStack == null || !ItemStack.m_41656_((ItemStack)this.playerItemStack, (ItemStack)handStack)) {
            this.playerItemStack = handStack;
            flag = true;
            this.displayItems.clear();
        }
        if (flag && !this.playerItemStack.m_41619_()) {
            this.updateDisplayItems();
            if (!this.displayItems.isEmpty()) {
                this.lookTime = 900;
                this.displayFirstItem();
            }
        }
    }

    private void displayFirstItem() {
        this.villager.m_8061_(EquipmentSlot.MAINHAND, this.displayItems.get(0));
    }

    private void updateDisplayItems() {
        for (MerchantOffer merchantoffer : this.villager.m_6616_()) {
            if (merchantoffer.m_45380_() || !this.playerItemStackMatchesCostOfOffer(merchantoffer)) continue;
            this.displayItems.add(merchantoffer.m_45368_());
        }
    }

    private boolean playerItemStackMatchesCostOfOffer(MerchantOffer offer) {
        return ItemStack.m_41656_((ItemStack)this.playerItemStack, (ItemStack)offer.m_45358_()) || ItemStack.m_41656_((ItemStack)this.playerItemStack, (ItemStack)offer.m_45364_());
    }

    private void displayCyclingItems() {
        if (this.displayItems.size() >= 2 && ++this.cycleCounter >= 40) {
            ++this.displayIndex;
            this.cycleCounter = 0;
            if (this.displayIndex > this.displayItems.size() - 1) {
                this.displayIndex = 0;
            }
            this.f_25512_.m_8061_(EquipmentSlot.MAINHAND, this.displayItems.get(this.displayIndex));
        }
    }
}

