/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.blocks.kinetics.hydraulic_press;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import uwu.lopyluna.create_dd.content.blocks.kinetics.hydraulic_press.HydraulicPressBlock;
import uwu.lopyluna.create_dd.infrastructure.config.DesiresConfigs;

public class HydraulicPressBlockEntity
extends MechanicalPressBlockEntity {
    SmartFluidTankBehaviour tank;

    public HydraulicPressBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluidInTank(0);
        if (!fluidStack.isEmpty()) {
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)this.tank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        } else if (fluidStack.isEmpty()) {
            Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)this.tank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        }
        Lang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float stressTotal = this.calculateStressApplied() * Math.abs(this.getTheoreticalSpeed());
        Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side.m_122434_() == ((Direction)this.m_58900_().m_61143_(HydraulicPressBlock.HORIZONTAL_FACING)).m_122427_().m_122434_() && side.m_122434_() != Direction.Axis.Y) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public static <C extends Container> boolean canCompress(Recipe<C> recipe) {
        if (!(recipe instanceof CraftingRecipe)) {
            return false;
        }
        NonNullList ingredients = recipe.m_7527_();
        return ingredients.size() == 4 || ingredients.size() == 9;
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe instanceof CraftingRecipe && !(recipe instanceof MechanicalCraftingRecipe) && HydraulicPressBlockEntity.canCompress(recipe) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe) || recipe.m_6671_() == AllRecipeTypes.COMPACTING.getType();
    }

    public boolean canProcessInBulk() {
        return (Boolean)DesiresConfigs.server().recipes.hydraulicBulkPressing.get();
    }

    public void onItemPressed(ItemStack result) {
        super.onItemPressed(result);
        this.drainFluid();
        if (this.getProcessFluid((Fluid)Fluids.f_76195_)) {
            this.award(AllAdvancements.PRESS);
        }
    }

    protected void drainFluid() {
        if (this.getProcessFluid((Fluid)Fluids.f_76195_)) {
            this.tank.getPrimaryHandler().drain(((Integer)DesiresConfigs.server().recipes.hydraulicLavaDrainPressing.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
        } else {
            this.tank.getPrimaryHandler().drain(((Integer)DesiresConfigs.server().recipes.hydraulicFluidDrainPressing.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean getProcessFluid(Fluid fluid) {
        return this.tank.getPrimaryHandler().getFluid().getFluid() == fluid;
    }

    public boolean canProcessWithFluid() {
        return !this.tank.isEmpty() && (this.getProcessFluid((Fluid)Fluids.f_76195_) || this.getProcessFluid((Fluid)Fluids.f_76193_)) && this.tank.getPrimaryHandler().getFluidAmount() >= 1000;
    }

    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        if (!this.canProcessWithFluid()) {
            return false;
        }
        return super.tryProcessInWorld(itemEntity, simulate);
    }

    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        if (!this.canProcessWithFluid()) {
            return false;
        }
        return super.tryProcessOnBelt(input, outputList, simulate);
    }
}

