/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.infrastructure.utility;

import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import uwu.lopyluna.create_dd.registry.DesiresTags;

public class VeinMining {
    public static final Vein NO_VEIN = new Vein(Collections.emptyList());

    @Nonnull
    public static Vein findVein(@Nullable BlockGetter reader, BlockPos pos) {
        if (reader == null) {
            return NO_VEIN;
        }
        ArrayList<BlockPos> ores = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        if (!VeinMining.validateExcavation(reader, pos)) {
            return NO_VEIN;
        }
        visited.add(pos);
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1)).forEach(p -> frontier.add(new BlockPos((Vec3i)p)));
        while (!frontier.isEmpty()) {
            BlockState currentState;
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            if (!visited.add(currentPos) || !VeinMining.isOre(currentState = reader.m_8055_(currentPos))) continue;
            ores.add(currentPos);
            BlockPos.m_121990_((BlockPos)currentPos.m_7918_(-1, -1, -1), (BlockPos)currentPos.m_7918_(1, 1, 1)).filter(((Predicate<BlockPos>)visited::contains).negate()).forEach(p -> frontier.add(new BlockPos((Vec3i)p)));
        }
        visited.clear();
        visited.addAll(ores);
        frontier.addAll(ores);
        return new Vein(ores);
    }

    private static boolean validateExcavation(BlockGetter reader, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        frontier.add(pos);
        frontier.add(pos.m_7494_());
        int posY = pos.m_123342_();
        while (!frontier.isEmpty()) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            BlockPos belowPos = currentPos.m_7495_();
            visited.add(currentPos);
            boolean lowerLayer = currentPos.m_123342_() == posY;
            BlockState currentState = reader.m_8055_(currentPos);
            BlockState belowState = reader.m_8055_(belowPos);
            if (!VeinMining.isOre(currentState)) continue;
            if (!lowerLayer && !pos.equals((Object)belowPos) && VeinMining.isOre(belowState)) {
                return false;
            }
            for (Direction direction : Iterate.directions) {
                BlockPos offset;
                if (direction == Direction.DOWN || direction == Direction.UP && !lowerLayer || visited.contains(offset = currentPos.m_121945_(direction))) continue;
                frontier.add(offset);
            }
        }
        return true;
    }

    public static boolean isOre(BlockState state) {
        return state.m_204336_(DesiresTags.forgeBlockTag("ores"));
    }

    public static class Vein
    extends AbstractBlockBreakQueue {
        private final List<BlockPos> ores;

        public Vein(List<BlockPos> ores) {
            this.ores = ores;
        }

        public void destroyBlocks(Level world, ItemStack toDamage, @Nullable Player playerEntity, BiConsumer<BlockPos, ItemStack> drop) {
            this.ores.forEach(this.makeCallbackFor(world, 0.5f, toDamage, playerEntity, drop));
        }
    }
}

