/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeDetachedDrawerRecipe
extends CustomRecipe {
    public UpgradeDetachedDrawerRecipe(ResourceLocation name, CraftingBookCategory cat) {
        super(name, cat);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        return this.findContext(inv) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, RegistryAccess access) {
        Context ctx = this.findContext(inv);
        if (ctx == null) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = ctx.drawer.m_41777_();
        DetachedDrawerData data = new DetachedDrawerData(ret.m_41784_());
        int cap = data.getStorageMultiplier();
        if (ctx.upgrades.isEmpty()) {
            ret = ((Item)ModItems.DETACHED_DRAWER.get()).m_7968_();
            data = new DetachedDrawerData();
            data.setStorageMultiplier(cap);
        } else {
            int addedCap = ctx.storageMult * (Integer)CommonConfig.GENERAL.baseStackStorage.get() * 8;
            data.setStorageMultiplier(data.getStorageMultiplier() + addedCap);
        }
        ret.m_41751_(data.serializeNBT());
        return ret;
    }

    @Nullable
    private Context findContext(CraftingContainer inv) {
        Context ret = new Context();
        for (int x = 0; x < inv.m_6643_(); ++x) {
            ItemStack stack = inv.m_8020_(x);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemDetachedDrawer) {
                if (!ret.drawer.m_41619_()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.m_41720_() instanceof ItemUpgradeStorage) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.m_41619_()) {
            return null;
        }
        for (ItemStack upgrade : ret.upgrades) {
            Item item = upgrade.m_41720_();
            if (!(item instanceof ItemUpgradeStorage)) continue;
            ItemUpgradeStorage storageUpgrade = (ItemUpgradeStorage)item;
            ret.storageMult += CommonConfig.UPGRADES.getLevelMult(storageUpgrade.level.getLevel());
        }
        return ret;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)StorageDrawers.DETACHED_UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        ItemStack drawer = ItemStack.f_41583_;
        List<ItemStack> upgrades = new ArrayList<ItemStack>();
        int storageMult = 0;

        private Context() {
        }
    }
}

