/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CompactingHelper {
    private static final InventoryLookup lookup1 = new InventoryLookup(1, 1);
    private static final InventoryLookup lookup2 = new InventoryLookup(2, 2);
    private static final InventoryLookup lookup3 = new InventoryLookup(3, 3);
    private final Level world;

    public CompactingHelper(Level world) {
        this.world = world;
    }

    @NotNull
    public Result findHigherTier(@NotNull ItemStack stack) {
        ItemStack modMatch;
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)CommonConfig.GENERAL.debugTrace.get();
        if (!this.world.f_46443_ && debugTrace) {
            StorageDrawers.log.info("Finding ascending candidates for " + stack.toString());
        }
        if ((record = StorageDrawers.compRegistry.findHigherTier(stack)) != null) {
            if (!this.world.f_46443_ && debugTrace) {
                StorageDrawers.log.info("Found " + record.upper.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.upper, record.convRate);
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        int lookupSize = this.setupLookup(lookup3, stack);
        List<ItemStack> fwdCandidates = this.findAllMatchingRecipes((CraftingContainer)lookup3);
        if (fwdCandidates.size() == 0) {
            lookupSize = this.setupLookup(lookup2, stack);
            fwdCandidates = this.findAllMatchingRecipes((CraftingContainer)lookup2);
        }
        if (fwdCandidates.size() > 0) {
            block0: for (ItemStack match : fwdCandidates) {
                this.setupLookup(lookup1, match);
                List<ItemStack> backCandidates = this.findAllMatchingRecipes((CraftingContainer)lookup1);
                for (ItemStack comp : backCandidates) {
                    if (comp.m_41613_() != lookupSize || !ItemStackMatcher.areItemsEqual(comp, stack)) continue;
                    candidates.add(match);
                    if (this.world.f_46443_ || !debugTrace) continue block0;
                    StorageDrawers.log.info("Found ascending candidate for " + stack.toString() + ": " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
                    continue block0;
                }
            }
        }
        if (!(modMatch = this.findMatchingModCandidate(stack, candidates)).m_41619_()) {
            return new Result(modMatch, lookupSize);
        }
        if (candidates.size() > 0) {
            return new Result((ItemStack)candidates.get(0), lookupSize);
        }
        if (!this.world.f_46443_ && debugTrace) {
            StorageDrawers.log.info("No candidates found");
        }
        return new Result(ItemStack.f_41583_, 0);
    }

    @NotNull
    public Result findLowerTier(@NotNull ItemStack stack) {
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)CommonConfig.GENERAL.debugTrace.get();
        if (!this.world.f_46443_ && debugTrace) {
            StorageDrawers.log.info("Finding descending candidates for " + stack.toString());
        }
        if ((record = StorageDrawers.compRegistry.findLowerTier(stack)) != null) {
            if (!this.world.f_46443_ && debugTrace) {
                StorageDrawers.log.info("Found " + record.lower.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.lower, record.convRate);
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> candidatesRate = new HashMap<ItemStack, Integer>();
        for (Recipe recipe : this.world.m_7465_().m_44013_(RecipeType.f_44107_)) {
            ItemStack match;
            ItemStack output = recipe.m_8043_(this.world.m_9598_());
            if (!ItemStackMatcher.areItemsEqual(stack, output) || (match = this.tryMatch(stack, (NonNullList<Ingredient>)recipe.m_7527_())).m_41619_()) continue;
            int lookupSize = this.setupLookup(lookup1, output);
            List<ItemStack> compMatches = this.findAllMatchingRecipes((CraftingContainer)lookup1);
            for (ItemStack comp : compMatches) {
                int recipeSize = recipe.m_7527_().size();
                if (ItemStackMatcher.areItemsEqual(match, comp) && comp.m_41613_() == recipeSize) {
                    candidates.add(match);
                    candidatesRate.put(match, recipeSize);
                    if (this.world.f_46443_ || !debugTrace) continue;
                    StorageDrawers.log.info("Found descending candidate for " + stack.toString() + ": " + match.toString() + " size=" + recipeSize + ", inverse=" + comp.toString());
                    continue;
                }
                if (this.world.f_46443_ || !debugTrace) continue;
                StorageDrawers.log.info("Back-check failed for " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
            }
        }
        ItemStack modMatch = this.findMatchingModCandidate(stack, candidates);
        if (!modMatch.m_41619_()) {
            return new Result(modMatch, (Integer)candidatesRate.get(modMatch));
        }
        if (candidates.size() > 0) {
            ItemStack match = (ItemStack)candidates.get(0);
            return new Result(match, (Integer)candidatesRate.get(match));
        }
        if (!this.world.f_46443_ && debugTrace) {
            StorageDrawers.log.info("No candidates found");
        }
        return new Result(ItemStack.f_41583_, 0);
    }

    private List<ItemStack> findAllMatchingRecipes(CraftingContainer crafting) {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        for (CraftingRecipe recipe : this.world.m_7465_().m_44056_(RecipeType.f_44107_, (Container)crafting, this.world)) {
            ItemStack result;
            if (!recipe.m_5818_((Container)crafting, this.world) || (result = recipe.m_5874_((Container)crafting, this.world.m_9598_())).m_41619_()) continue;
            candidates.add(result);
        }
        return candidates;
    }

    @NotNull
    private ItemStack findMatchingModCandidate(@NotNull ItemStack reference, List<ItemStack> candidates) {
        ResourceLocation referenceName = ForgeRegistries.ITEMS.getKey((Object)reference.m_41720_());
        if (referenceName != null) {
            for (ItemStack candidate : candidates) {
                ResourceLocation matchName = ForgeRegistries.ITEMS.getKey((Object)candidate.m_41720_());
                if (matchName == null || !referenceName.m_135827_().equals(matchName.m_135815_())) continue;
                return candidate;
            }
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    private ItemStack tryMatch(@NotNull ItemStack stack, NonNullList<Ingredient> ingredients) {
        if (ingredients.size() != 9 && ingredients.size() != 4) {
            return ItemStack.f_41583_;
        }
        Ingredient refIngredient = (Ingredient)ingredients.get(0);
        ItemStack[] refMatchingStacks = refIngredient.m_43908_();
        if (refMatchingStacks.length == 0) {
            return ItemStack.f_41583_;
        }
        int n = ingredients.size();
        for (int i = 1; i < n; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            @NotNull ItemStack match = ItemStack.f_41583_;
            for (ItemStack ingItemMatch : refMatchingStacks) {
                if (!ingredient.test(ingItemMatch)) continue;
                match = ingItemMatch;
                break;
            }
            if (!match.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        ItemStack match = this.findMatchingModCandidate(stack, Arrays.asList(refMatchingStacks));
        if (match.m_41619_()) {
            match = refMatchingStacks[0];
        }
        return match;
    }

    private int setupLookup(InventoryLookup inv, @NotNull ItemStack stack) {
        int n = inv.m_6643_();
        for (int i = 0; i < n; ++i) {
            inv.m_6836_(i, stack);
        }
        return inv.m_6643_();
    }

    public static class Result {
        @NotNull
        private final ItemStack stack;
        private final int size;

        public Result(@NotNull ItemStack stack, int size) {
            this.stack = stack;
            this.size = size;
        }

        @NotNull
        public ItemStack getStack() {
            return this.stack;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static class InventoryLookup
    extends TransientCraftingContainer {
        private final ItemStack[] stackList;

        public InventoryLookup(int width, int height) {
            super(null, width, height);
            this.stackList = new ItemStack[width * height];
            Arrays.fill(this.stackList, ItemStack.f_41583_);
        }

        public int m_6643_() {
            return this.stackList.length;
        }

        @NotNull
        public ItemStack m_8020_(int slot) {
            return slot >= this.m_6643_() ? ItemStack.f_41583_ : this.stackList[slot];
        }

        @NotNull
        public ItemStack m_8016_(int slot) {
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack m_7407_(int slot, int count) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int slot, @NotNull ItemStack stack) {
            this.stackList[slot] = stack;
        }
    }
}

