/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.entity;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.entity.WanderingWinemakerEntity;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.Nullable;

public class TraderMuleEntity
extends AbstractChestedHorse {
    private int despawnDelay = 47999;

    public TraderMuleEntity(EntityType<? extends TraderMuleEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42129_}), false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.maybeDespawn();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("DespawnDelay", this.despawnDelay);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("DespawnDelay", 99)) {
            this.despawnDelay = compoundTag.m_128451_("DespawnDelay");
        }
    }

    private void maybeDespawn() {
        if (this.canDespawn()) {
            int n = this.despawnDelay = this.isLeashedToWanderingTrader() ? ((WanderingTrader)Objects.requireNonNull(this.m_21524_())).m_35876_() - 1 : this.despawnDelay - 1;
            if (this.despawnDelay <= 0) {
                this.m_21455_(true, false);
                this.m_146870_();
            }
        }
    }

    private boolean canDespawn() {
        return !this.m_30614_() && !this.isLeashedToSomethingOtherThanTheWanderingTrader() && !this.m_146898_();
    }

    private boolean isLeashedToWanderingTrader() {
        return this.m_21524_() instanceof WanderingWinemakerEntity;
    }

    private boolean isLeashedToSomethingOtherThanTheWanderingTrader() {
        return this.m_21523_() && !this.isLeashedToWanderingTrader();
    }

    public TraderMuleEntity getBreedOffspring(ServerLevel serverWorld, AgeableMob passiveEntity) {
        return (TraderMuleEntity)((EntityType)EntityTypeRegistry.MULE.get()).m_20615_(this.m_9236_());
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_11809_;
    }

    protected SoundEvent m_7871_() {
        super.m_7871_();
        return SoundEvents.f_11810_;
    }

    protected SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_11812_;
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_11813_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        super.m_7975_(source);
        return SoundEvents.f_11814_;
    }
}

