/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockTagsProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemTagsProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;

public final class GatherDataHelper {
    private static final Map<String, Generator<DTLangProvider, String>> extraLangGenerators = new HashMap<String, Generator<DTLangProvider, String>>();

    public static void gatherAllData(String modId, GatherDataEvent event, Registry<?> ... registries) {
        GatherDataHelper.gatherTagData(modId, event);
        GatherDataHelper.gatherBlockStateAndModelData(modId, event, registries);
        GatherDataHelper.gatherItemModelData(modId, event, registries);
        GatherDataHelper.gatherLootData(modId, event);
        GatherDataHelper.gatherLangData(modId, event, registries);
    }

    public static void gatherTagData(String modId, GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DTBlockTagsProvider blockTagsProvider = new DTBlockTagsProvider(packOutput, lookupProvider, modId, event.getExistingFileHelper());
        DTItemTagsProvider itemTagsProvider = new DTItemTagsProvider(packOutput, modId, lookupProvider, blockTagsProvider.m_274426_(), event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)itemTagsProvider);
    }

    public static void gatherBlockStateAndModelData(String modId, GatherDataEvent event, Registry<?> ... registries) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new DTBlockStateProvider(event.getGenerator().getPackOutput(), modId, event.getExistingFileHelper(), Arrays.asList(registries)));
    }

    public static void gatherItemModelData(String modId, GatherDataEvent event, Registry<?> ... registries) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new DTItemModelProvider(event.getGenerator().getPackOutput(), modId, event.getExistingFileHelper(), Arrays.asList(registries)));
    }

    public static void gatherLootData(String modId, GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new DTLootTableProvider(event.getGenerator().getPackOutput(), modId, event.getExistingFileHelper()));
    }

    public static void gatherLangData(String modId, GatherDataEvent event, Registry<?> ... registries) {
        event.getGenerator().addProvider(event.includeClient(), (DataProvider)new DTLangProvider(event.getGenerator().getPackOutput(), modId, Arrays.asList(registries)));
    }

    public static void addLangGenerator(String modId, Generator<DTLangProvider, String> generator) {
        extraLangGenerators.put(modId, generator);
    }

    public static Map<String, Generator<DTLangProvider, String>> getExtraLangGenerators() {
        return extraLangGenerators;
    }
}

