/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.cell;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.SimpleRegistry;
import com.ferreusveritas.dynamictrees.cell.LeafClusters;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.resources.ResourceLocation;

public abstract class CellKit
extends RegistryEntry<CellKit> {
    public static final CellSolver NULL_CELL_SOLVER = cells -> 0;
    public static final CellKit NULL_CELL_KIT = new CellKit(DTTrees.NULL){

        @Override
        public Cell getCellForLeaves(int hydro) {
            return CellNull.NULL_CELL;
        }

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return CellNull.NULL_CELL;
        }

        @Override
        public CellSolver getCellSolver() {
            return NULL_CELL_SOLVER;
        }

        @Override
        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.NULL_MAP;
        }

        @Override
        public int getDefaultHydration() {
            return 0;
        }
    };
    public static final SimpleRegistry<CellKit> REGISTRY = new SimpleRegistry<CellKit>(CellKit.class, NULL_CELL_KIT);

    public CellKit(ResourceLocation registryName) {
        this.setRegistryName(registryName);
    }

    public abstract Cell getCellForLeaves(int var1);

    public abstract Cell getCellForBranch(int var1, int var2);

    public abstract CellSolver getCellSolver();

    public abstract SimpleVoxmap getLeafCluster();

    public abstract int getDefaultHydration();
}

