/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.api.registry.ConcurrentRegistry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;

public class RegistryHandler
extends RegistryEntry<RegistryHandler> {
    public static final ConcurrentRegistry<RegistryHandler> REGISTRY = new ConcurrentRegistry<RegistryHandler>(RegistryHandler.class, new RegistryHandler("null"), true);
    private static final Method ADD_ENTRIES_METHOD;
    protected final DeferredRegister<Block> blocksDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)this.getRegistryName().m_135827_());
    protected final DeferredRegister<Item> itemsDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)this.getRegistryName().m_135827_());

    public static void setup(String modId) {
        RegistryHandler registryHandler = new RegistryHandler(modId);
        REGISTRY.register(registryHandler);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(new RegisterEventHandler<Block>(registryHandler.blocksDeferredRegister));
        modEventBus.register(new RegisterEventHandler<Item>(registryHandler.itemsDeferredRegister));
    }

    public static RegistryHandler get(String modId) {
        return (RegistryHandler)REGISTRY.get(new ResourceLocation(modId, modId));
    }

    public static RegistryHandler getOrCorrected(String modId) {
        RegistryHandler handler = RegistryHandler.get(modId);
        return handler.isValid() ? handler : RegistryHandler.get("dynamictrees");
    }

    public static ResourceLocation correctRegistryName(ResourceLocation registryName) {
        if (!RegistryHandler.get(registryName.m_135827_()).isValid()) {
            registryName = ResourceLocationUtils.namespace(registryName, "dynamictrees");
        }
        return registryName;
    }

    public static <T extends Block> RegistryObject<T> addBlock(ResourceLocation registryName, Supplier<T> blockSup) {
        registryName = RegistryHandler.correctRegistryName(registryName);
        return RegistryHandler.get(registryName.m_135827_()).putBlock(registryName, blockSup);
    }

    public static <T extends Item> RegistryObject<T> addItem(ResourceLocation registryName, Supplier<T> itemSup) {
        registryName = RegistryHandler.correctRegistryName(registryName);
        return RegistryHandler.get(registryName.m_135827_()).putItem(registryName, itemSup);
    }

    public RegistryHandler(String modId) {
        super(new ResourceLocation(modId, modId));
    }

    @Nullable
    public RegistryObject<Block> getBlock(ResourceLocation registryName) {
        return RegistryObject.create((ResourceLocation)registryName, (IForgeRegistry)ForgeRegistries.BLOCKS);
    }

    @Nullable
    public RegistryObject<Item> getItem(ResourceLocation registryName) {
        return RegistryObject.create((ResourceLocation)registryName, (IForgeRegistry)ForgeRegistries.ITEMS);
    }

    public <T extends Block> RegistryObject<T> putBlock(ResourceLocation registryName, Supplier<T> blockSup) {
        if (this.warnIfInvalid("Block", registryName)) {
            return this.getBlock(registryName);
        }
        return this.blocksDeferredRegister.register(registryName.m_135815_(), blockSup);
    }

    public <T extends Item> RegistryObject<T> putItem(ResourceLocation registryName, Supplier<T> itemSup) {
        if (this.warnIfInvalid("Item", registryName)) {
            return this.getItem(registryName);
        }
        return this.itemsDeferredRegister.register(registryName.m_135815_(), itemSup);
    }

    private boolean warnIfInvalid(String type, ResourceLocation registryName) {
        if (!this.isValid()) {
            LogManager.getLogger().warn("{} '{}' was added to null registry handler.", (Object)type, (Object)registryName);
        }
        return !this.isValid();
    }

    static {
        try {
            ADD_ENTRIES_METHOD = DeferredRegister.class.getDeclaredMethod("addEntries", RegisterEvent.class);
            ADD_ENTRIES_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class RegisterEventHandler<T> {
        private final DeferredRegister<T> deferredRegister;

        public RegisterEventHandler(DeferredRegister<T> deferredRegister) {
            this.deferredRegister = deferredRegister;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onRegister(RegisterEvent event) {
            if (event.getRegistryKey() == this.deferredRegister.getRegistryKey()) {
                try {
                    ADD_ENTRIES_METHOD.invoke(this.deferredRegister, event);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

