/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.branch;

import com.ferreusveritas.dynamictrees.block.BlockWithDynamicHardness;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.Musable;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.Null;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public class TrunkShellBlock
extends BlockWithDynamicHardness
implements SimpleWaterloggedBlock {
    public static final EnumProperty<CoordUtils.Surround> CORE_DIR = EnumProperty.m_61587_((String)"coredir", CoordUtils.Surround.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public TrunkShellBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278183_().m_278166_(PushReaction.BLOCK));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CORE_DIR}).m_61104_(new Property[]{WATERLOGGED});
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ShellMuse muse = this.getMuseUnchecked((BlockGetter)level, state, pos);
        if (!this.isValid(muse)) {
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                level.m_46597_(pos, Blocks.f_49990_.m_49966_());
            } else {
                level.m_7471_(pos, false);
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return Null.applyIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> muse.state.m_60734_().onDestroyedByPlayer(muse.state, level, muse.pos, player, willHarvest, level.m_6425_(pos)), false);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return Null.applyIfNonnull(this.getMuse(level, state, pos), muse -> Float.valueOf(muse.state.m_60734_().m_5880_(muse.state, player, level, muse.pos)), Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        return Null.applyIfNonnull(this.getMuse(level, pos), muse -> Float.valueOf(((BlockWithDynamicHardness)muse.state.m_60734_()).getHardness(state, level, muse.pos)), Float.valueOf(super.getHardness(state, level, pos))).floatValue();
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return Null.applyIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> muse.state.m_60734_().getSoundType(muse.state, level, muse.pos, entity), SoundType.f_56736_);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return Null.applyIfNonnull(this.getMuse(level, pos), muse -> Float.valueOf(muse.state.m_60734_().getExplosionResistance(level.m_8055_(pos), level, muse.pos, explosion)), Float.valueOf(0.0f)).floatValue();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        BlockPos clickedPos;
        Level level = useContext.m_43725_();
        if (this.museDoesNotExist((BlockGetter)level, state, clickedPos = useContext.m_8083_())) {
            this.scheduleUpdateTick((BlockGetter)level, clickedPos);
            return false;
        }
        return false;
    }

    public CoordUtils.Surround getMuseDir(BlockState state, BlockPos pos) {
        return (CoordUtils.Surround)((Object)state.m_61143_(CORE_DIR));
    }

    public boolean museDoesNotExist(BlockGetter level, BlockState state, BlockPos pos) {
        BlockPos musePos = pos.m_121955_(this.getMuseDir(state, pos).getOffset());
        return CoordUtils.getStateSafe(level, musePos) == null;
    }

    @Nullable
    public ShellMuse getMuseUnchecked(BlockGetter level, BlockPos pos) {
        return this.getMuseUnchecked(level, level.m_8055_(pos), pos);
    }

    @Nullable
    public ShellMuse getMuseUnchecked(BlockGetter level, BlockState state, BlockPos pos) {
        return this.getMuseUnchecked(level, state, pos, pos);
    }

    @Nullable
    public ShellMuse getMuseUnchecked(BlockGetter level, BlockState state, BlockPos pos, BlockPos originalPos) {
        CoordUtils.Surround museDir = this.getMuseDir(state, pos);
        BlockPos musePos = pos.m_121955_(museDir.getOffset());
        BlockState museState = CoordUtils.getStateSafe(level, musePos);
        if (museState == null) {
            return null;
        }
        Block block = museState.m_60734_();
        if (block instanceof Musable && ((Musable)block).isMusable(level, museState, musePos)) {
            return new ShellMuse(museState, musePos, museDir, musePos.m_121996_((Vec3i)originalPos));
        }
        if (block instanceof TrunkShellBlock) {
            Vec3i offset = ((TrunkShellBlock)block).getMuseDir(museState, musePos).getOffset();
            Vec3 vec3 = new Vec3((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
            Vec3 vec32 = new Vec3((double)museDir.getOffset().m_123341_(), (double)museDir.getOffset().m_123342_(), (double)museDir.getOffset().m_123343_());
            if (vec3.m_82549_(vec32).m_82556_() > 2.25) {
                return ((TrunkShellBlock)block).getMuseUnchecked(level, museState, musePos, originalPos);
            }
        }
        return null;
    }

    @Nullable
    public ShellMuse getMuse(BlockGetter level, BlockPos pos) {
        return this.getMuse(level, level.m_8055_(pos), pos);
    }

    @Nullable
    public ShellMuse getMuse(BlockGetter level, BlockState state, BlockPos pos) {
        ShellMuse muse = this.getMuseUnchecked(level, state, pos);
        if (!this.isValid(muse)) {
            this.scheduleUpdateTick(level, pos);
        }
        return muse;
    }

    protected boolean isValid(@Nullable ShellMuse muse) {
        return muse != null && muse.getRadius() > 8;
    }

    public void scheduleUpdateTick(BlockGetter level, BlockPos pos) {
        if (!(level instanceof LevelAccessor)) {
            return;
        }
        ((LevelAccessor)level).m_183326_().m_183393_(new ScheduledTick((Object)this, pos.m_7949_(), 0L, TickPriority.HIGH, 0L));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean p_220069_6_) {
        this.scheduleUpdateTick((BlockGetter)level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Null.applyIfNonnull(this.getMuse(level, state, pos), muse -> Shapes.m_83064_((AABB)muse.state.m_60808_(level, muse.pos).m_83215_().m_82338_(muse.museOffset)), Shapes.m_83040_());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return Null.applyIfNonnull(this.getMuse(level, state, pos), muse -> muse.state.m_60734_().getCloneItemStack(muse.state, target, level, muse.pos, player), ItemStack.f_41583_);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        Null.consumeIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> muse.state.m_60734_().onBlockExploded(muse.state, level, muse.pos, explosion));
    }

    @Nullable
    protected CoordUtils.Surround findDetachedMuse(Level level, BlockPos pos) {
        for (CoordUtils.Surround s : CoordUtils.Surround.values()) {
            BlockState state = level.m_8055_(pos.m_121955_(s.getOffset()));
            if (!(state.m_60734_() instanceof Musable)) continue;
            return s;
        }
        return null;
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockState newState = level.m_8055_(pos);
        if (newState.m_60734_() != Blocks.f_50016_) {
            return;
        }
        Null.consumeIfNonnull(this.findDetachedMuse((Level)level, pos), surround -> level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_(CORE_DIR, (Comparable)((Object)surround)), 1));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        return Null.applyIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> muse.state.m_60734_().m_6227_(muse.state, level, muse.pos, playerIn, hand, hit), InteractionResult.FAIL);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 0;
    }

    public boolean isFullBlockShell(BlockGetter level, BlockPos pos) {
        return this.isFullBlockShell(this.getMuse(level, pos));
    }

    public boolean isFullBlockShell(@Nullable ShellMuse muse) {
        return muse != null && this.isFullBlockShell(muse.getRadius());
    }

    public boolean isFullBlockShell(int radius) {
        return (radius - 8) % 16 == 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_183324_().m_183393_(new ScheduledTick((Object)Fluids.f_76193_, currentPos, (long)Fluids.f_76193_.m_6718_((LevelReader)level), 0L));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.isFullBlockShell(level, pos)) {
            return false;
        }
        return super.m_6044_(level, pos, state, fluid);
    }

    public boolean isWaterLogged(BlockState state) {
        return state.m_61138_((Property)WATERLOGGED) && (Boolean)state.m_61143_((Property)WATERLOGGED) != false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                if (!(target instanceof BlockHitResult)) {
                    return false;
                }
                BlockPos shellPos = ((BlockHitResult)target).m_82425_();
                if (state.m_60734_() instanceof TrunkShellBlock) {
                    ShellMuse muse = ((TrunkShellBlock)state.m_60734_()).getMuseUnchecked((BlockGetter)level, state, shellPos);
                    if (muse == null) {
                        return true;
                    }
                    BlockState museState = muse.state;
                    BlockPos musePos = muse.pos;
                    RandomSource rand = level.f_46441_;
                    int x = musePos.m_123341_();
                    int y = musePos.m_123342_();
                    int z = musePos.m_123343_();
                    AABB axisalignedbb = museState.m_60816_((BlockGetter)level, musePos).m_83215_();
                    double d0 = (double)x + rand.m_188500_() * (axisalignedbb.f_82291_ - axisalignedbb.f_82288_ - 0.2) + 0.1 + axisalignedbb.f_82288_;
                    double d1 = (double)y + rand.m_188500_() * (axisalignedbb.f_82292_ - axisalignedbb.f_82289_ - 0.2) + 0.1 + axisalignedbb.f_82289_;
                    double d2 = (double)z + rand.m_188500_() * (axisalignedbb.f_82293_ - axisalignedbb.f_82290_ - 0.2) + 0.1 + axisalignedbb.f_82290_;
                    switch (((BlockHitResult)target).m_82434_()) {
                        case DOWN: {
                            d1 = (double)y + axisalignedbb.f_82289_ - 0.1;
                            break;
                        }
                        case UP: {
                            d1 = (double)y + axisalignedbb.f_82292_ + 0.1;
                            break;
                        }
                        case NORTH: {
                            d2 = (double)z + axisalignedbb.f_82290_ - 0.1;
                            break;
                        }
                        case SOUTH: {
                            d2 = (double)z + axisalignedbb.f_82293_ + 0.1;
                            break;
                        }
                        case WEST: {
                            d0 = (double)x + axisalignedbb.f_82288_ - 0.1;
                            break;
                        }
                        case EAST: {
                            d0 = (double)x + axisalignedbb.f_82291_ + 0.1;
                        }
                    }
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, museState), d0, d1, d2, 0.0, 0.0, 0.0);
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                if (state.m_60734_() instanceof TrunkShellBlock) {
                    ShellMuse muse = ((TrunkShellBlock)state.m_60734_()).getMuseUnchecked((BlockGetter)level, state, pos);
                    if (muse == null) {
                        return true;
                    }
                    BlockState museState = muse.state;
                    BlockPos musePos = muse.pos;
                    manager.m_107355_(musePos, museState);
                }
                return true;
            }
        });
    }

    public static class ShellMuse {
        public final BlockState state;
        public final BlockPos pos;
        public final BlockPos museOffset;
        public final CoordUtils.Surround dir;

        public ShellMuse(BlockState state, BlockPos pos, CoordUtils.Surround dir, BlockPos museOffset) {
            this.state = state;
            this.pos = pos;
            this.dir = dir;
            this.museOffset = museOffset;
        }

        public int getRadius() {
            Block block = this.state.m_60734_();
            return block instanceof BranchBlock ? ((BranchBlock)block).getRadius(this.state) : 0;
        }
    }
}

