/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.command.HexColorArgument;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.item.Staff;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class CreateStaffCommand
extends SubCommand {
    private static final String COLOR = "color";
    private static final String READ_ONLY = "readOnly";
    private static final String MAX_USES = "maxUses";
    private static final int DEFAULT_COLOUR = 65535;
    private static final boolean DEFAULT_READ_ONLY = false;
    private static final int DEFAULT_MAX_USES = 64;

    @Override
    protected String getName() {
        return "createstaff";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return CreateStaffCommand.blockPosArgument().then(((RequiredArgumentBuilder)CreateStaffCommand.speciesArgument().executes(context -> this.spawnStaff((CommandSourceStack)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSourceStack>)context), "JP", 65535, false, 64))).then(((RequiredArgumentBuilder)CreateStaffCommand.stringArgument("jo_code").suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)CreateStaffCommand.speciesArgument((CommandContext<CommandSourceStack>)context).getJoCodes().stream().map(JoCode::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.spawnStaff((CommandSourceStack)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), 65535, false, 64))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)COLOR, (ArgumentType)HexColorArgument.hex()).executes(context -> this.spawnStaff((CommandSourceStack)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), HexColorArgument.getHexCode(context, COLOR), false, 64))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)READ_ONLY, (ArgumentType)BoolArgumentType.bool()).executes(context -> this.spawnStaff((CommandSourceStack)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), HexColorArgument.getHexCode(context, COLOR), BoolArgumentType.getBool((CommandContext)context, (String)READ_ONLY), 64))).then(CreateStaffCommand.intArgument(MAX_USES).suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)Stream.of(1, 3, 32, 64, 128).map(String::valueOf).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.spawnStaff((CommandSourceStack)context.getSource(), CreateStaffCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.speciesArgument((CommandContext<CommandSourceStack>)context), CreateStaffCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), HexColorArgument.getHexCode(context, COLOR), BoolArgumentType.getBool((CommandContext)context, (String)READ_ONLY), CreateStaffCommand.intArgument((CommandContext<CommandSourceStack>)context, MAX_USES))))))));
    }

    private int spawnStaff(CommandSourceStack source, BlockPos pos, Species species, String code, int colour, boolean readOnly, int maxUses) {
        Staff staff = DTRegistries.STAFF.get();
        ItemStack wandStack = new ItemStack((ItemLike)staff, 1);
        staff.setSpecies(wandStack, species).setCode(wandStack, code).setColor(wandStack, colour).setReadOnly(wandStack, readOnly).setMaxUses(wandStack, maxUses).setUses(wandStack, maxUses);
        ItemUtils.spawnItemStack((Level)source.m_81372_(), pos, wandStack, true);
        CreateStaffCommand.sendSuccessAndLog(source, (Component)Component.m_237110_((String)"commands.dynamictrees.success.create_staff", (Object[])new Object[]{species.getTextComponent(), new JoCode(code).getTextComponent(), CreateStaffCommand.aqua(String.format("#%08X", colour)), CreateStaffCommand.aqua(readOnly), CreateStaffCommand.aqua(maxUses), CommandHelper.posComponent((Vec3i)pos, ChatFormatting.AQUA)}));
        return 1;
    }
}

