/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat;

import com.ferreusveritas.dynamictrees.api.season.SeasonManager;
import com.ferreusveritas.dynamictrees.compat.season.NormalSeasonManager;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.compat.season.SereneSeasonsSeasonProvider;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;

public final class CompatHandler {
    private static final LinkedHashMap<String, Supplier<SeasonManager>> SEASON_MANAGERS = Maps.newLinkedHashMap();
    public static final String DISABLED = "!";
    public static final String ANY = "*";

    public static void registerSeasonManager(String modId, Supplier<SeasonManager> supplier) {
        SEASON_MANAGERS.put(modId, supplier);
    }

    public static void registerBuiltInSeasonManagers() {
        if (ModList.get().isLoaded("sereneseasons")) {
            SereneSeasonsSeasonProvider.registerSereneSeasonsProvider();
        }
    }

    public static void reloadSeasonManager() {
        String modId = (String)DTConfigs.PREFERRED_SEASON_MOD.get();
        if (Objects.equals(modId, DISABLED)) {
            SeasonHelper.setSeasonManager(NormalSeasonManager.NULL.get());
            return;
        }
        if (Objects.equals(modId, ANY)) {
            SeasonHelper.setSeasonManager(SEASON_MANAGERS.entrySet().stream().filter(entry -> ModList.get().isLoaded((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(NormalSeasonManager.NULL).get());
            return;
        }
        if (!ModList.get().isLoaded(modId)) {
            LogManager.getLogger().warn("Preferred season mod \"{}\" not installed.", (Object)modId);
            return;
        }
        if (!SEASON_MANAGERS.containsKey(modId)) {
            LogManager.getLogger().warn("Season manager not found for preferred season mod \"{}\".", (Object)modId);
            return;
        }
        SeasonHelper.setSeasonManager(SEASON_MANAGERS.get(modId).get());
    }
}

