/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class MapDeserialiser<K, V>
implements JsonDeserialiser<Map<K, V>> {
    private final JsonDeserialiser<K> keyGetter;
    private final JsonDeserialiser<V> valueGetter;
    private final Supplier<Map<K, V>> mapSupplier;

    public MapDeserialiser(JsonDeserialiser<K> keyGetter, JsonDeserialiser<V> valueGetter) {
        this(keyGetter, valueGetter, HashMap::new);
    }

    public MapDeserialiser(JsonDeserialiser<K> keyGetter, JsonDeserialiser<V> valueGetter, Supplier<Map<K, V>> mapSupplier) {
        this.keyGetter = keyGetter;
        this.valueGetter = valueGetter;
        this.mapSupplier = mapSupplier;
    }

    @Override
    public Result<Map<K, V>, JsonElement> deserialise(JsonElement jsonElement) {
        return JsonDeserialisers.JSON_OBJECT.deserialise(jsonElement).map((object, warningConsumer) -> {
            Map map = this.mapSupplier.get();
            for (Map.Entry entry : object.entrySet()) {
                this.valueGetter.deserialise((JsonElement)entry.getValue()).map(value -> this.keyGetter.deserialise(new JsonPrimitive((String)entry.getKey())).ifSuccessOrElseThrow(key -> map.put(key, value), (Consumer<String>)warningConsumer)).orElseThrow();
            }
            return map;
        });
    }

    public static <K, V> Class<Map<K, V>> getMapClass(Class<K> keyClass, Class<V> valueClass) {
        return MapDeserialiser.getMapClass(keyClass, valueClass, HashMap::new);
    }

    public static <K, V> Class<Map<K, V>> getMapClass(Class<K> keyClass, Class<V> valueClass, Supplier<Map<K, V>> mapSupplier) {
        return mapSupplier.get().getClass();
    }
}

