/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation.result;

import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.result.MappedResult;
import com.ferreusveritas.dynamictrees.util.function.ThrowableBiFunction;
import com.ferreusveritas.dynamictrees.util.function.ThrowableFunction;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface Result<T, I> {
    public I getInput();

    public T get() throws NoSuchElementException;

    default public Result<T, I> ifSuccess(Consumer<T> consumer) {
        if (this.success()) {
            consumer.accept(this.get());
        }
        return this;
    }

    default public Result<T, I> ifSuccessOrElse(Consumer<T> consumer, Consumer<String> errorConsumer, Consumer<String> warningConsumer) {
        if (this.success()) {
            consumer.accept(this.get());
        } else if (this.getError() != null) {
            errorConsumer.accept(this.getError());
        }
        this.getWarnings().forEach(warningConsumer);
        return this;
    }

    default public Result<T, I> ifSuccessOrElseThrow(Consumer<T> consumer, Consumer<String> warningConsumer) throws DeserialisationException {
        if (this.success()) {
            consumer.accept(this.get());
        } else if (this.getError() != null) {
            throw new DeserialisationException(this.getError());
        }
        this.getWarnings().forEach(warningConsumer);
        return this;
    }

    public T orElse(T var1);

    default public T orElse(T other, Consumer<String> errorConsumer, Consumer<String> warningConsumer) {
        if (!this.success()) {
            errorConsumer.accept(this.getError());
        }
        this.getWarnings().forEach(warningConsumer);
        return this.orElse(other);
    }

    default public T orElseApply(Function<String, T> function, T other) {
        if (this.success()) {
            return this.get();
        }
        if (this.getError() != null) {
            return function.apply(this.getError());
        }
        return other;
    }

    default public T orElseApply(Function<String, T> function, BiConsumer<T, List<String>> warningAppender, T other) {
        if (this.success()) {
            warningAppender.accept(this.get(), this.getWarnings());
            return this.get();
        }
        if (this.getError() != null) {
            other = function.apply(this.getError());
        }
        warningAppender.accept(other, this.getWarnings());
        return other;
    }

    public T orElseGet(Supplier<T> var1);

    public T orElseThrow() throws DeserialisationException;

    @Nullable
    public String getError();

    public Result<T, I> forEachWarning(Consumer<String> var1);

    public List<String> getWarnings();

    public boolean success();

    public Result<T, I> removeError();

    default public <V> MappedResult<V, I> map(SimpleMapper<T, V> mapper) {
        return this.map(mapper.fullMapper());
    }

    public <V> MappedResult<V, I> map(Mapper<T, V> var1);

    default public <V> MappedResult<V, I> map(SimpleMapper<T, V> mapper, String nullError) {
        return this.map(mapper.fullMapper(), nullError);
    }

    default public <V> MappedResult<V, I> map(Mapper<T, V> mapper, String nullError) {
        return this.map(mapper, Objects::nonNull, nullError);
    }

    default public <V> MappedResult<V, I> map(SimpleMapper<T, V> mapper, Predicate<V> validator, String invalidError) {
        return this.map(mapper.fullMapper(), validator, invalidError);
    }

    public <V> MappedResult<V, I> map(Mapper<T, V> var1, Predicate<V> var2, String var3);

    default public <V> MappedResult<V, I> mapIfValid(Predicate<T> validator, String invalidError, SimpleMapper<T, V> mapper) {
        return this.mapIfValid(validator, invalidError, mapper.fullMapper());
    }

    public <V> MappedResult<V, I> mapIfValid(Predicate<T> var1, String var2, Mapper<T, V> var3);

    default public <V, N> MappedResult<N, I> mapIfType(Class<V> type, SimpleMapper<V, N> mapper) {
        return this.mapIfType(type, mapper.fullMapper());
    }

    public <V, N> MappedResult<N, I> mapIfType(Class<V> var1, Mapper<V, N> var2);

    public <E> MappedResult<List<E>, I> mapToListOfType(Class<E> var1);

    default public <V, E> MappedResult<List<E>, I> mapEachIfArray(Class<V> elementType, SimpleMapper<V, E> mapper) {
        return this.mapEachIfArray(elementType, mapper.fullMapper());
    }

    public <V, E> MappedResult<List<E>, I> mapEachIfArray(Class<V> var1, Mapper<V, E> var2);

    default public <E, V> MappedResult<V, I> mapIfContains(String key, Class<E> type, SimpleMapper<E, V> mapper) {
        return this.mapIfContains(key, type, mapper.fullMapper());
    }

    public <E, V> MappedResult<V, I> mapIfContains(String var1, Class<E> var2, Mapper<E, V> var3);

    default public <E, V> MappedResult<V, I> mapIfContains(String key, Class<E> type, SimpleMapper<E, V> mapper, V defaultValue) {
        return this.mapIfContains(key, type, mapper.fullMapper(), defaultValue);
    }

    public <E, V> MappedResult<V, I> mapIfContains(String var1, Class<E> var2, Mapper<E, V> var3, V var4);

    @FunctionalInterface
    public static interface SimpleMapper<T, V>
    extends ThrowableFunction<T, V, DeserialisationException> {
        default public Mapper<T, V> fullMapper() {
            return (value, warningConsumer) -> this.apply(value);
        }
    }

    @FunctionalInterface
    public static interface Mapper<T, V>
    extends ThrowableBiFunction<T, Consumer<String>, V, DeserialisationException> {
    }
}

