/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class NetherFungusLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> MIN_CAP_HEIGHT = ConfigurationProperty.integer("min_cap_height");

    public NetherFungusLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(MIN_CAP_HEIGHT, 3)).with(HEIGHT_VARIATION, 8);
    }

    @Override
    protected void registerProperties() {
        this.register(MIN_CAP_HEIGHT, HEIGHT_VARIATION);
    }

    @Override
    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        if (context.signal().isInTrunk() && newDir != Direction.UP) {
            context.signal().energy = Math.min(context.signal().energy, context.species().isMegaSpecies() ? 3.0f : 2.0f);
        }
        return newDir;
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        if (context.signal().isInTrunk()) {
            if (TreeHelper.isBranch(context.level().m_8055_(context.pos().m_7494_())) && !TreeHelper.isBranch(context.level().m_8055_(context.pos().m_6630_(3)))) {
                context.probMap(new int[]{0, 0, 0, 0, 0, 0});
            } else if (!context.species().isMegaSpecies()) {
                for (Direction direction : CoordUtils.HORIZONTALS) {
                    if (!TreeHelper.isBranch(context.level().m_8055_(context.pos().m_121955_(direction.m_122424_().m_122436_())))) continue;
                    probMap[direction.m_122411_()] = 0;
                }
            }
            probMap[Direction.UP.m_122411_()] = 4;
        } else {
            probMap[Direction.UP.m_122411_()] = 0;
        }
        return probMap;
    }

    private float getHashedVariation(GrowthLogicKitConfiguration configuration, Level level, BlockPos pos) {
        long day = level.m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode(pos.m_6630_(month), 2) % (Integer)configuration.get(HEIGHT_VARIATION);
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return Math.min((float)(configuration.getLowestBranchHeight(new PositionalSpeciesContext(context.level(), context.pos(), context.species())) + configuration.get(MIN_CAP_HEIGHT)) + this.getHashedVariation(configuration, context.level(), context.pos()) / 1.5f, super.getEnergy(configuration, context));
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) * context.species().biomeSuitability(context.level(), context.pos()) + this.getHashedVariation(configuration, context.level(), context.pos()));
    }
}

