/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.entry;

import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.entry.DTLootPoolEntries;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemBySpeciesLootPoolEntry
extends LootPoolSingletonContainer {
    private final Map<ResourceLocation, Item> items;

    public ItemBySpeciesLootPoolEntry(int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions, Map<ResourceLocation, Item> items) {
        super(weight, quality, conditions, functions);
        this.items = items;
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)DTLootPoolEntries.ITEM_BY_SPECIES.get();
    }

    protected void m_6948_(Consumer<ItemStack> stackConsumer, LootContext context) {
        Species species = (Species)context.m_78953_(DTLootContextParams.SPECIES);
        assert (species != null);
        Item item = this.items.get(species.getRegistryName());
        if (item == null) {
            item = Items.f_41852_;
        }
        stackConsumer.accept(new ItemStack((ItemLike)item));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<ItemBySpeciesLootPoolEntry> {
        public void serializeCustom(JsonObject json, ItemBySpeciesLootPoolEntry value, JsonSerializationContext context) {
            super.m_6170_(json, (LootPoolEntryContainer)value, context);
            JsonObject itemsJson = new JsonObject();
            for (Map.Entry<ResourceLocation, Item> itemEntry : value.items.entrySet()) {
                itemsJson.add(itemEntry.getKey().toString(), (JsonElement)new JsonPrimitive(ForgeRegistries.ITEMS.getKey((Object)itemEntry.getValue()).toString()));
            }
            json.add("name_by_species", (JsonElement)itemsJson);
        }

        protected ItemBySpeciesLootPoolEntry deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            JsonObject namesJson = GsonHelper.m_13930_((JsonObject)json, (String)"name_by_species");
            HashMap items = Maps.newHashMap();
            for (Map.Entry itemEntry : namesJson.entrySet()) {
                items.put(new ResourceLocation((String)itemEntry.getKey()), GsonHelper.m_13874_((JsonElement)((JsonElement)itemEntry.getValue()), (String)((String)itemEntry.getKey())));
            }
            return new ItemBySpeciesLootPoolEntry(weight, quality, conditions, functions, items);
        }
    }
}

