/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class FallingTreeEntityModel
extends EntityModel<FallingTreeEntity> {
    protected final List<TreeQuadData> quads;
    protected final int entityId;
    protected final Species species;

    public FallingTreeEntityModel(FallingTreeEntity entity) {
        Level world = entity.m_20193_();
        BranchDestructionData destructionData = entity.getDestroyData();
        Species species = destructionData.species;
        this.quads = FallingTreeEntityModel.generateTreeQuads(entity);
        this.species = species;
        this.entityId = entity.m_19879_();
    }

    public List<TreeQuadData> getQuads() {
        return this.quads;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static int getBrightness(FallingTreeEntity entity) {
        BranchDestructionData destructionData = entity.getDestroyData();
        Level world = entity.m_9236_();
        return world.m_8055_(destructionData.cutPos).getLightEmission((BlockGetter)world, destructionData.cutPos);
    }

    public static List<TreeQuadData> generateTreeQuads(FallingTreeEntity entity) {
        ArrayList<TreeQuadData> treeQuads;
        block10: {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BranchDestructionData destructionData = entity.getDestroyData();
            Direction cutDir = destructionData.cutDir;
            treeQuads = new ArrayList<TreeQuadData>();
            int[] connectionArray = new int[6];
            if (destructionData.getNumBranches() <= 0) break block10;
            BlockState exState = destructionData.getBranchBlockState(0);
            BlockPos cutPos = destructionData.cutPos;
            if (exState != null) {
                BlockPos relPos;
                RootyBlock rootyBlock;
                Species species = destructionData.species;
                BlockPos rootPos = cutPos.m_7495_();
                BlockState bottomState = entity.m_9236_().m_8055_(rootPos);
                boolean rootyBlockAdded = false;
                if (TreeHelper.isRooty(bottomState) && (rootyBlock = TreeHelper.getRooty(bottomState)) != null && rootyBlock.fallWithTree(bottomState, entity.m_9236_(), rootPos, !destructionData.getRelativeCutPos().equals((Object)BlockPos.f_121853_))) {
                    BakedModel rootyModel = dispatcher.m_110910_(bottomState);
                    BlockPos cutOffset = destructionData.getRelativeCutPos();
                    treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(rootyModel, bottomState, new Vec3((double)cutOffset.m_123341_(), (double)(cutOffset.m_123342_() - 1), (double)cutOffset.m_123343_()), ModelData.EMPTY), destructionData.species.getFamily().getRootColor(bottomState, rootyBlock.getColorFromBark()), bottomState));
                    rootyBlockAdded = true;
                }
                BakedModel branchModel = dispatcher.m_110910_(exState);
                destructionData.getConnections(0, connectionArray);
                boolean bottomRingsAdded = false;
                if (!rootyBlockAdded && connectionArray[cutDir.m_122411_()] > 0) {
                    BlockPos offsetPos = destructionData.getRelativeCutPos().m_121945_(cutDir);
                    float offset = (float)(8 - Math.min(((BranchBlock)exState.m_60734_()).getRadius(exState), 8)) / 16.0f;
                    treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(branchModel, exState, new Vec3((double)offsetPos.m_123341_(), (double)offsetPos.m_123342_(), (double)offsetPos.m_123343_()).m_82490_((double)offset), new Direction[]{null}, new ModelConnections(cutDir).setFamily(TreeHelper.getBranch(exState)).toModelData()), exState));
                    bottomRingsAdded = true;
                }
                for (int index = 0; index < destructionData.getNumBranches(); ++index) {
                    Block previousBranch = exState.m_60734_();
                    if (!previousBranch.equals((exState = destructionData.getBranchBlockState(index)).m_60734_())) {
                        branchModel = dispatcher.m_110910_(exState);
                    }
                    relPos = destructionData.getBranchRelPos(index);
                    destructionData.getConnections(index, connectionArray);
                    ModelConnections modelConnections = new ModelConnections(connectionArray).setFamily(TreeHelper.getBranch(exState));
                    if (index == 0 && bottomRingsAdded) {
                        modelConnections.setForceRing(cutDir);
                    }
                    treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(branchModel, exState, new Vec3((double)relPos.m_123341_(), (double)relPos.m_123342_(), (double)relPos.m_123343_()), modelConnections.toModelData()), exState));
                }
                HashMap<BlockPos, BlockState> leavesClusters = species.getFellingLeavesClusters(destructionData);
                if (leavesClusters != null) {
                    for (Map.Entry<BlockPos, BlockState> leafLoc : leavesClusters.entrySet()) {
                        leafState = leafLoc.getValue();
                        treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(dispatcher.m_110910_(leafState), leafState, new Vec3((double)leafLoc.getKey().m_123341_(), (double)leafLoc.getKey().m_123342_(), (double)leafLoc.getKey().m_123343_()), ModelData.EMPTY), species.leafColorMultiplier(entity.m_9236_(), cutPos.m_121955_((Vec3i)leafLoc.getKey())), leafState));
                    }
                } else {
                    for (int index = 0; index < destructionData.getNumLeaves(); ++index) {
                        relPos = destructionData.getLeavesRelPos(index);
                        leafState = destructionData.getLeavesBlockState(index);
                        BakedModel leavesModel = dispatcher.m_110910_(leafState);
                        treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(leavesModel, leafState, new Vec3((double)relPos.m_123341_(), (double)relPos.m_123342_(), (double)relPos.m_123343_()), ModelData.EMPTY), destructionData.getLeavesProperties(index).treeFallColorMultiplier(leafState, (BlockAndTintGetter)entity.m_9236_(), cutPos.m_121955_((Vec3i)relPos)), leafState));
                    }
                }
            }
        }
        return treeQuads;
    }

    public void setupAnim(FallingTreeEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (TreeQuadData treeQuad : this.getQuads()) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            BakedQuad bakedQuad = treeQuad.bakedQuad;
            if (bakedQuad.m_111304_()) {
                int color = this.species == null ? treeQuad.color : this.species.colorTreeQuads(treeQuad.color, treeQuad);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            }
            if (bakedQuad.m_111307_()) {
                float diffuse = 0.8f;
                r *= diffuse;
                g *= diffuse;
                b *= diffuse;
            }
            buffer.m_85987_(poseStack.m_85850_(), bakedQuad, r, g, b, packedLight, packedOverlay);
        }
    }

    public static List<TreeQuadData> toTreeQuadData(List<BakedQuad> bakedQuads, BlockState state) {
        return FallingTreeEntityModel.toTreeQuadData(bakedQuads, 0xFFFFFF, state);
    }

    public static List<TreeQuadData> toTreeQuadData(List<BakedQuad> bakedQuads, int defaultColor, BlockState state) {
        return bakedQuads.stream().map(bakedQuad -> new TreeQuadData((BakedQuad)bakedQuad, defaultColor, state)).collect(Collectors.toList());
    }

    public static final class TreeQuadData {
        public final BakedQuad bakedQuad;
        public final BlockState state;
        public final int color;

        public TreeQuadData(BakedQuad bakedQuad, int color, BlockState state) {
            this.bakedQuad = bakedQuad;
            this.state = state;
            this.color = color;
        }
    }
}

