/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources;

import com.ferreusveritas.dynamictrees.api.resource.TreeResourceManager;
import com.ferreusveritas.dynamictrees.api.resource.TreeResourcePack;
import com.ferreusveritas.dynamictrees.api.resource.loading.ApplierResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.ResourceLoader;
import com.ferreusveritas.dynamictrees.util.CommonCollectors;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public final class TreesResourceManager
implements ResourceManager,
TreeResourceManager {
    private final List<TreeResourcePack> resourcePacks = Lists.newArrayList();
    private final List<ResourceLoader<?>> resourceLoaders = Lists.newArrayList();

    @Override
    public void addLoader(ResourceLoader<?> loader) {
        this.resourceLoaders.add(loader);
    }

    @Override
    public void addLoaders(ResourceLoader<?> ... loaders) {
        this.resourceLoaders.addAll(Arrays.asList(loaders));
    }

    @Override
    public void addLoaderBefore(ResourceLoader<?> loader, ResourceLoader<?> existing) {
        this.resourceLoaders.add(this.resourceLoaders.indexOf(existing), loader);
    }

    @Override
    public void addLoaderAfter(ResourceLoader<?> loader, ResourceLoader<?> existing) {
        this.resourceLoaders.add(this.resourceLoaders.indexOf(existing) + 1, loader);
    }

    @Override
    public void registerAppliers() {
        this.resourceLoaders.stream().filter(ApplierResourceLoader.class::isInstance).map(ApplierResourceLoader.class::cast).forEach(ApplierResourceLoader::registerAppliers);
    }

    @Override
    public void load() {
        this.resourceLoaders.forEach(loader -> loader.load(this).join());
    }

    @Override
    public void gatherData() {
        this.resourceLoaders.forEach(loader -> loader.gatherData(this).join());
    }

    @Override
    public void setup() {
        this.resourceLoaders.forEach(loader -> loader.setup(this).join());
    }

    @Override
    public CompletableFuture<?>[] prepareReload(Executor gameExecutor, Executor backgroundExecutor) {
        return (CompletableFuture[])this.resourceLoaders.stream().map(loader -> loader.prepareReload(this)).toArray(CompletableFuture[]::new);
    }

    @Override
    public void reload(CompletableFuture<?>[] futures) {
        for (int i = 0; i < futures.length; ++i) {
            this.reload(this.resourceLoaders.get(i), futures[i]);
        }
    }

    private <R> void reload(ResourceLoader<R> loader, CompletableFuture<?> future) {
        loader.reload(future, this);
    }

    @Override
    public void addPack(TreeResourcePack pack) {
        this.resourcePacks.add(pack);
    }

    public Set<String> m_7187_() {
        return this.resourcePacks.stream().map(TreeResourcePack::getNamespaces).flatMap(Collection::stream).collect(CommonCollectors.toLinkedSet());
    }

    public Optional<Resource> m_213713_(ResourceLocation location) {
        List<Resource> resources = this.m_213829_(location);
        return resources.isEmpty() ? Optional.empty() : Optional.of(resources.get(resources.size() - 1));
    }

    public Resource m_215593_(ResourceLocation location) throws FileNotFoundException {
        return this.m_213713_(location).orElseThrow(() -> new FileNotFoundException("Could not find path '" + location + "' in any tree packs."));
    }

    public List<Resource> m_213829_(ResourceLocation path) {
        return this.resourcePacks.stream().filter(resourcePack -> resourcePack.hasResource(path)).map(resourcePack -> this.getResource(path, (TreeResourcePack)resourcePack)).toList();
    }

    private Resource getResource(ResourceLocation path, TreeResourcePack resourcePack) {
        return new Resource((PackResources)resourcePack, resourcePack.getResource(path));
    }

    public Map<ResourceLocation, Resource> m_214159_(String path, Predicate<ResourceLocation> filter) {
        LinkedHashMap<ResourceLocation, Resource> resources = new LinkedHashMap<ResourceLocation, Resource>();
        for (TreeResourcePack pack : this.resourcePacks) {
            for (String namespace : pack.getNamespaces()) {
                pack.listResources(namespace, path, (loc, resource) -> {
                    if (filter.test((ResourceLocation)loc)) {
                        resources.put((ResourceLocation)loc, this.getResource((ResourceLocation)loc, pack));
                    }
                });
            }
        }
        return resources;
    }

    public Map<ResourceLocation, List<Resource>> m_214160_(String path, Predicate<ResourceLocation> filter) {
        LinkedHashMap<ResourceLocation, List<Resource>> resources = new LinkedHashMap<ResourceLocation, List<Resource>>();
        for (TreeResourcePack pack : this.resourcePacks) {
            for (String namespace : pack.getNamespaces()) {
                pack.listResources(namespace, path, (loc, resource) -> {
                    if (filter.test((ResourceLocation)loc)) {
                        resources.computeIfAbsent((ResourceLocation)loc, this::m_213829_);
                    }
                });
            }
        }
        return resources;
    }

    @Override
    public Stream<PackResources> m_7536_() {
        return this.resourcePacks.stream();
    }
}

