/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SpreadableSoilProperties;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.ResourceLocationDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolderRegistry;

public final class SoilPropertiesResourceLoader
extends JsonRegistryResourceLoader<SoilProperties> {
    public SoilPropertiesResourceLoader() {
        super(SoilProperties.REGISTRY, "soil_properties");
    }

    @Override
    public void registerAppliers() {
        this.loadAppliers.register("substitute_soil", String.class, (soilProperties, substitute) -> soilProperties.setHasSubstitute(true));
        this.gatherDataAppliers.register("primitive_soil", Block.class, SoilProperties::setPrimitiveSoilBlock).register("only_if_loaded", String.class, SoilProperties::setOnlyIfLoaded).registerArrayApplier("only_if_loaded", String.class, SoilProperties::setOnlyIfLoaded).registerMapApplier("model_overrides", ResourceLocation.class, SoilProperties::setModelOverrides).registerMapApplier("texture_overrides", ResourceLocation.class, SoilProperties::setTextureOverrides);
        this.setupAppliers.register("primitive_soil", Block.class, SoilProperties::setPrimitiveSoilBlock);
        this.reloadAppliers.register("foliage_tint_index", Integer.class, SoilProperties::setFoliageTintIndex).register("roots_tint_index", Integer.class, SoilProperties::setRootsTintIndex);
        this.registerSpreadableAppliers();
        this.commonAppliers.registerArrayApplier("acceptable_soils", String.class, this::registerAcceptableSoil);
        super.registerAppliers();
    }

    private void registerAcceptableSoil(SoilProperties soilProperties, String acceptableSoil) {
        if (SoilHelper.getSoilFlags(acceptableSoil) == 0) {
            SoilHelper.createNewAdjective(acceptableSoil);
        }
        SoilHelper.registerSoil(soilProperties, acceptableSoil);
    }

    private void registerSpreadableAppliers() {
        this.reloadAppliers.register("required_light", SpreadableSoilProperties.class, Integer.class, SpreadableSoilProperties::setRequiredLight).register("spread_item", SpreadableSoilProperties.class, Item.class, SpreadableSoilProperties::setSpreadItem).registerArrayApplier("spreadable_soils", SpreadableSoilProperties.class, SoilProperties.class, (properties, soil) -> SoilProperties.REGISTRY.runOnNextLock(() -> properties.addSpreadableSoils((SoilProperties)soil)));
    }

    @Override
    protected void applyLoadAppliers(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        this.readCustomBlockRegistryName((SoilProperties)loadData.getResource(), json);
        super.applyLoadAppliers(loadData, json);
    }

    private void readCustomBlockRegistryName(SoilProperties soilProperties, JsonObject json) {
        JsonResult.forInput((JsonElement)json).mapIfContains("block_registry_name", JsonElement.class, input -> ResourceLocationDeserialiser.create(soilProperties.getRegistryName().m_135827_()).deserialise((JsonElement)input).orElseThrow(), soilProperties.getBlockRegistryName()).ifSuccessOrElse(soilProperties::setBlockRegistryName, error -> this.logError(soilProperties.getRegistryName(), (String)error), warning -> this.logWarning(soilProperties.getRegistryName(), (String)warning));
    }

    @Override
    protected void postLoadOnLoad(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.postLoadOnLoad(loadData, json);
        SoilProperties soilProperties = (SoilProperties)loadData.getResource();
        if (soilProperties.hasSubstitute()) {
            SoilProperties.REGISTRY.runOnNextLock(() -> this.setSubstituteSoil(soilProperties, json));
        } else {
            this.generateSoilBlock(soilProperties, json);
        }
    }

    private void setSubstituteSoil(SoilProperties soilProperties, JsonObject json) {
        SoilProperties substitute = JsonHelper.getOrDefault(json, "substitute_soil", SoilProperties.class, SoilProperties.NULL_SOIL_PROPERTIES);
        if (substitute.isValid()) {
            this.useSubstituteSoilBlock(soilProperties, substitute);
        }
    }

    private void useSubstituteSoilBlock(SoilProperties soilProperties, SoilProperties substitute) {
        ObjectHolderRegistry.addHandler(registryNameFilter -> {
            Object patt5798$temp;
            if (registryNameFilter.test(ForgeRegistries.Keys.BLOCKS.m_135782_()) && (patt5798$temp = ForgeRegistries.BLOCKS.getValue(substitute.getBlockRegistryName())) instanceof RootyBlock) {
                RootyBlock rootyBlock = (RootyBlock)patt5798$temp;
                soilProperties.setBlock(rootyBlock);
            }
        });
    }

    private void generateSoilBlock(SoilProperties soilProperties, JsonObject json) {
        soilProperties.generateBlock(JsonHelper.getBlockProperties(json, soilProperties.getDefaultMapColor(), soilProperties::getDefaultBlockProperties, error -> this.logError(soilProperties.getRegistryName(), (String)error), warning -> this.logWarning(soilProperties.getRegistryName(), (String)warning)));
    }
}

