/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.cell.LeafClusters;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.util.function.BiomePredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BushGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> LOG = ConfigurationProperty.block("log");
    public static final ConfigurationProperty<Block> LEAVES = ConfigurationProperty.block("leaves");
    public static final ConfigurationProperty<Block> SECONDARY_LEAVES = ConfigurationProperty.block("secondary_leaves");
    public static final ConfigurationProperty<Integer> SECONDARY_LEAVES_CHANCE = ConfigurationProperty.integer("secondary_leaves_chance");

    public BushGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(BIOME_PREDICATE, LOG, LEAVES, SECONDARY_LEAVES, SECONDARY_LEAVES_CHANCE);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BIOME_PREDICATE, i -> true)).with(LOG, Blocks.f_49999_)).with(LEAVES, Blocks.f_50050_)).with(SECONDARY_LEAVES, null)).with(SECONDARY_LEAVES_CHANCE, 4);
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        this.commonGen(configuration, context.level(), context.pos(), context.species(), context.random(), context.radius(), context.bounds());
        return true;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.bounds() != SafeChunkBounds.ANY && ((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.biome())) {
            this.commonGen(configuration, context.level(), context.pos(), context.species(), context.random(), context.radius(), context.bounds());
            return true;
        }
        return false;
    }

    protected void commonGen(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, Species species, RandomSource random, int radius, SafeChunkBounds safeBounds) {
        if (radius <= 2) {
            return;
        }
        boolean worldGen = safeBounds != SafeChunkBounds.ANY;
        Vec3 vTree = new Vec3((double)rootPos.m_123341_(), (double)rootPos.m_123342_(), (double)rootPos.m_123343_()).m_82520_(0.5, 0.5, 0.5);
        for (int i = 0; i < 2; ++i) {
            int rad = Mth.m_14045_((int)(random.m_188503_(radius - 2) + 2), (int)2, (int)(radius - 1));
            Vec3 v = vTree.m_82549_(new Vec3(1.0, 0.0, 0.0).m_82490_((double)rad).m_82524_((float)((double)random.m_188501_() * Math.PI * 2.0)));
            BlockPos vPos = BlockPos.m_274446_((Position)v);
            if (!safeBounds.inBounds(vPos, true)) continue;
            BlockPos groundPos = CoordUtils.findWorldSurface(level, vPos, worldGen);
            BlockState soilBlockState = level.m_8055_(groundPos);
            BlockPos pos = groundPos.m_7494_();
            if (level.m_8055_(groundPos).m_278721_() || !species.isAcceptableSoil((LevelReader)level, groundPos, soilBlockState)) continue;
            level.m_7731_(pos, configuration.get(LOG).m_49966_(), 3);
            SimpleVoxmap leafMap = LeafClusters.BUSH;
            BlockPos.MutableBlockPos leafPos = new BlockPos.MutableBlockPos();
            for (BlockPos.MutableBlockPos dPos : leafMap.getAllNonZero()) {
                leafPos.m_122178_(pos.m_123341_() + dPos.m_123341_(), pos.m_123342_() + dPos.m_123342_(), pos.m_123343_() + dPos.m_123343_());
                if (!safeBounds.inBounds((BlockPos)leafPos, true) || BushGenFeature.coordHashCode((BlockPos)leafPos) % 5 == 0 || !level.m_8055_((BlockPos)leafPos).m_247087_()) continue;
                this.placeLeaves(configuration, level, random, (BlockPos)leafPos);
            }
        }
    }

    private void placeLeaves(GenFeatureConfiguration configuration, LevelAccessor level, RandomSource random, BlockPos leafPos) {
        Block leavesBlock = this.selectLeavesBlock(random, configuration.get(SECONDARY_LEAVES_CHANCE), configuration.get(LEAVES), configuration.getAsOptional(SECONDARY_LEAVES).orElse(null));
        this.placeLeavesBlock(level, leafPos, leavesBlock);
    }

    private Block selectLeavesBlock(RandomSource random, int secondaryLeavesChance, Block leavesBlock, @Nullable Block secondaryLeavesBlock) {
        return secondaryLeavesBlock == null || random.m_188503_(secondaryLeavesChance) != 0 ? leavesBlock : secondaryLeavesBlock;
    }

    private void placeLeavesBlock(LevelAccessor level, BlockPos leafPos, Block leavesBlock) {
        BlockState leafState = leavesBlock.m_49966_();
        if (leavesBlock instanceof LeavesBlock) {
            leafState = (BlockState)leafState.m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
        }
        level.m_7731_(leafPos, leafState, 3);
    }

    public static int coordHashCode(BlockPos pos) {
        int hash = (pos.m_123341_() * 4111 ^ pos.m_123342_() * 271 ^ pos.m_123343_() * 3067) >> 1;
        return hash & 0xFFFF;
    }
}

