/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PreGenerationContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class MoundGenFeature
extends GenFeature {
    private static final SimpleVoxmap moundMap = new SimpleVoxmap(5, 4, 5, new byte[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 0, 0, 1, 1, 1, 0, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    public static final ConfigurationProperty<Integer> MOUND_CUTOFF_RADIUS = ConfigurationProperty.integer("mound_cutoff_radius");

    public MoundGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MOUND_CUTOFF_RADIUS);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(MOUND_CUTOFF_RADIUS, 5);
    }

    @Override
    protected BlockPos preGenerate(GenFeatureConfiguration configuration, PreGenerationContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        if (context.radius() >= configuration.get(MOUND_CUTOFF_RADIUS) && context.isWorldGen()) {
            BlockState initialDirtState = level.m_8055_(rootPos);
            BlockState initialUnderState = level.m_8055_(rootPos.m_7495_());
            rootPos = rootPos.m_7494_();
            for (SimpleVoxmap.Cell cell : moundMap.getAllNonZeroCells()) {
                BlockState placeState = cell.getValue() == 1 ? initialDirtState : initialUnderState;
                level.m_7731_(rootPos.m_121955_((Vec3i)cell.getPos()), placeState, 3);
            }
        }
        return rootPos;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.radius() >= configuration.get(MOUND_CUTOFF_RADIUS) || !context.isWorldGen()) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        BlockPos treePos = rootPos.m_7494_();
        BlockState belowState = level.m_8055_(rootPos.m_7495_());
        BlockState branchState = level.m_8055_(treePos);
        if (TreeHelper.getTreePart(branchState).getRadius(branchState) > 8) {
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = rootPos.m_121955_(dir.getOffset());
                level.m_7731_(dPos, context.initialDirtState(), 3);
                level.m_7731_(dPos.m_7495_(), belowState, 3);
            }
            return true;
        }
        return false;
    }
}

