/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.TallGrassBlock;

public class PodzolGenFeature
extends GenFeature {
    public PodzolGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!((Boolean)DTConfigs.PODZOL_GEN.get()).booleanValue()) {
            return false;
        }
        LevelAccessor level = context.level();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot(level, context.pos(), new MapSignal(endFinder));
        List<BlockPos> endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        RandomSource random = context.random();
        BlockPos pos = endPoints.get(random.m_188503_(endPoints.size()));
        int x = pos.m_123341_() + random.m_188503_(5) - 2;
        int z = pos.m_123343_() + random.m_188503_(5) - 2;
        int darkThreshold = 4;
        for (int i = 0; i < 32; ++i) {
            Block block;
            BlockPos offPos = new BlockPos(x, pos.m_123342_() - 1 - i, z);
            if (level.m_46859_(offPos) || (block = level.m_8055_(offPos).m_60734_()) instanceof BranchBlock || block instanceof MushroomBlock || block instanceof LeavesBlock) continue;
            if (block instanceof FlowerBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock) {
                if (level.m_45517_(LightLayer.SKY, offPos) > 4) continue;
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (block != Blocks.f_50493_ && block != Blocks.f_50034_) break;
            if (level.m_45517_(LightLayer.SKY, offPos.m_7494_()) <= 4) {
                level.m_7731_(offPos, BlockStates.PODZOL, 3);
                break;
            }
            PodzolGenFeature.spreadPodzol(level, pos);
            break;
        }
        return true;
    }

    public static void spreadPodzol(LevelAccessor level, BlockPos pos) {
        int podzolish = 0;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockPos deltaPos = pos.m_121945_(dir);
            Block testBlock = level.m_8055_(deltaPos).m_60734_();
            podzolish += testBlock == Blocks.f_50599_ ? 1 : 0;
            if ((podzolish += testBlock instanceof RootyBlock ? 1 : 0) < 3) continue;
            level.m_7731_(pos, BlockStates.PODZOL, 3);
            break;
        }
    }
}

