/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemapper;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class DenuderNode
implements NodeInspector {
    private final Species species;
    private final Family family;

    public DenuderNode(Species species, Family family) {
        this.species = species;
        this.family = family;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch == null || this.family.getBranch().map(other -> branch != other).orElse(false).booleanValue()) {
            return false;
        }
        int radius = branch.getRadius(state);
        branch.stripBranch(state, level, pos, radius);
        if (radius <= this.family.getPrimaryThickness()) {
            this.removeSurroundingLeaves(level, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void removeSurroundingLeaves(LevelAccessor world, BlockPos twigPos) {
        if (world.m_5776_()) {
            return;
        }
        SimpleVoxmap leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
        int xBound = leafCluster.getLenX();
        int yBound = leafCluster.getLenY();
        int zBound = leafCluster.getLenZ();
        BlockPos.m_121990_((BlockPos)twigPos.m_7918_(-xBound, -yBound, -zBound), (BlockPos)twigPos.m_7918_(xBound, yBound, zBound)).forEach(testPos -> {
            if (leafCluster.getVoxel(twigPos, (BlockPos)testPos) == 0) {
                return;
            }
            BlockState state = world.m_8055_(testPos);
            if (this.family.isCompatibleGenericLeaves(this.species, state, world, (BlockPos)testPos)) {
                world.m_7731_(testPos, BlockStates.AIR, 3);
            }
        });
    }
}

