/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.family;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.RootsItemModelGenerator;
import com.ferreusveritas.dynamictrees.api.data.RootsStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BasicRootsBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.AerialRootsSoilProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.MangroveSpecies;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;

public class MangroveFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(MangroveFamily::new);
    private AerialRootsSoilProperties defaultSoil;
    private Supplier<BranchBlock> roots;
    private Supplier<Item> rootsItem;
    private Block primitiveRoots;
    private Block primitiveRootsFilled;
    private Block primitiveRootsCovered;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> rootsStateGenerator = MutableLazyValue.supplied(RootsStateGenerator::new);
    protected final MutableLazyValue<Generator<DTItemModelProvider, Family>> rootsItemModelGenerator = MutableLazyValue.supplied(RootsItemModelGenerator::new);
    protected int rootSystemSoilTypeFlags = 0;
    private int primaryRootThickness = 2;
    private int secondaryRootThickness = 3;
    private int supportedRootThicknessExtra = 2;

    public MangroveFamily(ResourceLocation name) {
        super(name);
    }

    @Override
    public void setCommonSpecies(Species species) {
        super.setCommonSpecies(species);
        if (!(species instanceof MangroveSpecies)) {
            LogManager.getLogger().warn("Common species " + species.getRegistryName() + " for mangrove family " + this.getRegistryName() + "is not of type " + MangroveSpecies.class);
        }
    }

    public void setDefaultSoil(SoilProperties defaultSoil) {
        if (!(defaultSoil instanceof AerialRootsSoilProperties)) {
            throw new RuntimeException("Soil " + defaultSoil.toString() + " for mangrove family " + this + " is not of type " + AerialRootsSoilProperties.class);
        }
        this.defaultSoil = (AerialRootsSoilProperties)defaultSoil;
        this.defaultSoil.setFamily(this);
    }

    public AerialRootsSoilProperties getDefaultSoil() {
        return this.defaultSoil;
    }

    @Override
    public void setupBlocks() {
        super.setupBlocks();
        this.setRoots(this.createRoots(this.getBranchName()));
        this.setRootsItem(this.createRootsItem(this.getBranchName(), this.roots));
    }

    protected Supplier<BranchBlock> createRoots(ResourceLocation name) {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(name, this.getRootsNameSuffix()), () -> this.createRootsBlock(name));
    }

    protected BranchBlock createRootsBlock(ResourceLocation name) {
        BasicRootsBlock branch = new BasicRootsBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    public Supplier<BlockItem> createRootsItem(ResourceLocation registryName, Supplier<BranchBlock> rootsSup) {
        return RegistryHandler.addItem(ResourceLocationUtils.suffix(registryName, this.getRootsNameSuffix()), () -> new BlockItem((Block)rootsSup.get(), new Item.Properties()));
    }

    protected String getRootsNameSuffix() {
        return "_roots";
    }

    public Family setRoots(Supplier<BranchBlock> branchSup) {
        this.roots = this.setupBranch(branchSup, false);
        return this;
    }

    protected <T extends Item> Family setRootsItem(Supplier<T> branchItemSup) {
        this.rootsItem = branchItemSup;
        return this;
    }

    public Optional<BranchBlock> getRoots() {
        return Optionals.ofBlock(this.roots);
    }

    public Optional<Item> getRootsItem() {
        return Optionals.ofItem(this.rootsItem);
    }

    @Override
    public Optional<BranchBlock> getBranchForRootsPlacement(LevelAccessor level, Species species, BlockPos pos) {
        return this.getRoots();
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        super.generateStateData(provider);
        this.rootsStateGenerator.get().generate(provider, this);
    }

    @Override
    public void generateItemModelData(DTItemModelProvider provider) {
        super.generateItemModelData(provider);
        this.rootsItemModelGenerator.get().generate(provider, this);
    }

    @Override
    public ResourceLocation getBranchItemParentLocation() {
        return DynamicTrees.location("item/branch");
    }

    public List<TagKey<Block>> defaultRootsTags() {
        return Collections.singletonList(DTBlockTags.ROOTS);
    }

    @Nullable
    public Tier getDefaultRootsHarvestTier() {
        return null;
    }

    @Override
    public boolean isAcceptableSoilForRootSystem(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, this.rootSystemSoilTypeFlags);
    }

    public Family addAcceptableSoilsForRootSystem(String ... soilTypes) {
        this.rootSystemSoilTypeFlags |= SoilHelper.getSoilFlags(soilTypes);
        return this;
    }

    @Override
    public int getPrimaryRootThickness() {
        return this.primaryRootThickness;
    }

    @Override
    public int getSecondaryRootThickness() {
        return this.secondaryRootThickness;
    }

    public int getSupportedRootThicknessExtra() {
        return this.supportedRootThicknessExtra;
    }

    public void setPrimaryRootThickness(int primaryRootThickness) {
        this.primaryRootThickness = primaryRootThickness;
    }

    public void setSecondaryRootThickness(int secondaryRootThickness) {
        this.secondaryRootThickness = secondaryRootThickness;
    }

    public void setSupportedRootThicknessExtra(int supportedRootThicknessExtra) {
        this.supportedRootThicknessExtra = supportedRootThicknessExtra;
    }

    public void setPrimitiveRoots(Block primitiveRoots) {
        this.primitiveRoots = primitiveRoots;
        if (this.roots != null) {
            this.roots.get().setPrimitiveLogDrops(new ItemStack((ItemLike)primitiveRoots));
        }
    }

    public void setPrimitiveRootsFilled(Block primitiveRootsFilled) {
        this.primitiveRootsFilled = primitiveRootsFilled;
    }

    public void setPrimitiveRootsCovered(Block primitiveRootsCovered) {
        this.primitiveRootsCovered = primitiveRootsCovered;
    }

    public Optional<Block> getPrimitiveRoots() {
        return Optionals.ofBlock(this.primitiveRoots);
    }

    public Optional<Block> getPrimitiveFilledRoots() {
        return Optionals.ofBlock(this.primitiveRootsFilled);
    }

    public Optional<Block> getPrimitiveCoveredRoots() {
        return Optionals.ofBlock(this.primitiveRootsCovered);
    }

    @Override
    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        super.addGeneratedBlockTags(tagAppender);
        this.getRoots().ifPresent(roots -> {
            this.tierTag(this.getDefaultRootsHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.m_255245_(roots));
            this.defaultRootsTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_255245_(roots);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_176839_(BuiltInRegistries.f_256975_.m_7981_(roots));
                }
            });
        });
    }
}

