/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;

public class BlockBounds
implements Iterable<BlockPos> {
    public static final BlockBounds INVALID = new BlockBounds(){

        @Override
        public boolean inBounds(BlockPos pos) {
            return false;
        }
    };
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    private BlockBounds() {
    }

    public BlockBounds(BlockPos pos) {
        this.minX = this.maxX = pos.m_123341_();
        this.minY = this.maxY = pos.m_123342_();
        this.minZ = this.maxZ = pos.m_123343_();
    }

    public BlockBounds(BlockPos min, BlockPos max) {
        this.minX = min.m_123341_();
        this.minY = min.m_123342_();
        this.minZ = min.m_123343_();
        this.maxX = max.m_123341_();
        this.maxY = max.m_123342_();
        this.maxZ = max.m_123343_();
    }

    public BlockBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BlockBounds(LevelAccessor level, ChunkPos cPos) {
        this.minX = cPos.m_45604_();
        this.minY = level.m_141937_();
        this.minZ = cPos.m_45605_();
        this.maxX = cPos.m_45608_();
        this.maxY = level.m_151558_();
        this.maxZ = cPos.m_45609_();
    }

    public BlockBounds(BlockBounds other) {
        this.minX = other.minX;
        this.minY = other.minY;
        this.minZ = other.minZ;
        this.maxX = other.maxX;
        this.maxY = other.maxY;
        this.maxZ = other.maxZ;
    }

    public BlockBounds(List<BlockPos> blockPosList) {
        this(blockPosList.get(0));
        this.union(blockPosList);
    }

    public BlockBounds union(BlockPos pos) {
        if (pos.m_123341_() < this.minX) {
            this.minX = pos.m_123341_();
        } else if (pos.m_123341_() > this.maxX) {
            this.maxX = pos.m_123341_();
        }
        if (pos.m_123342_() < this.minY) {
            this.minY = pos.m_123342_();
        } else if (pos.m_123342_() > this.maxY) {
            this.maxY = pos.m_123342_();
        }
        if (pos.m_123343_() < this.minZ) {
            this.minZ = pos.m_123343_();
        } else if (pos.m_123343_() > this.maxZ) {
            this.maxZ = pos.m_123343_();
        }
        return this;
    }

    public BlockBounds union(List<BlockPos> blockPosList) {
        blockPosList.forEach(this::union);
        return this;
    }

    public boolean inBounds(BlockPos pos) {
        return pos.m_123341_() >= this.minX && pos.m_123341_() <= this.maxX && pos.m_123342_() >= this.minY && pos.m_123342_() <= this.maxY && pos.m_123343_() >= this.minZ && pos.m_123343_() <= this.maxZ;
    }

    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public BlockBounds expand(Direction dir, int amount) {
        switch (dir) {
            case DOWN: {
                this.minY -= amount;
                break;
            }
            case UP: {
                this.maxY += amount;
                break;
            }
            case NORTH: {
                this.minZ -= amount;
                break;
            }
            case SOUTH: {
                this.maxZ += amount;
                break;
            }
            case WEST: {
                this.minX -= amount;
                break;
            }
            case EAST: {
                this.maxX += amount;
            }
        }
        return this;
    }

    public BlockBounds shrink(Direction dir, int amount) {
        return this.expand(dir, -amount);
    }

    public BlockBounds move(int x, int y, int z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public BlockBounds move(BlockPos offset) {
        return this.move(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
    }

    public BlockBounds expand(int amount) {
        this.minX -= amount;
        this.minY -= amount;
        this.minZ -= amount;
        this.maxX += amount;
        this.maxY += amount;
        this.maxZ += amount;
        return this;
    }

    public BlockBounds shrink(int amount) {
        return this.expand(-amount);
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return BlockPos.m_121976_((int)this.minX, (int)this.minY, (int)this.minZ, (int)this.maxX, (int)this.maxY, (int)this.maxZ).iterator();
    }

    public int getXSize() {
        return this.maxX - this.minX + 1;
    }

    public int getYSize() {
        return this.maxY - this.minY + 1;
    }

    public int getZSize() {
        return this.maxZ - this.minZ + 1;
    }

    public String toString() {
        return this != INVALID ? "Bounds{x1=" + this.minX + ", y1=" + this.minY + ", z1=" + this.minZ + " -> x2=" + this.maxX + ", y2=" + this.maxY + ", z2=" + this.maxZ + "}" : "Invalid";
    }
}

