/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.util.AlternateLinkedHashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collector;

public final class CommonCollectors {
    public static <T> Collector<T, ?, LinkedHashSet<T>> toLinkedSet() {
        return Collector.of(LinkedHashSet::new, HashSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, AlternateLinkedHashSet<T>> toAlternateLinkedSet() {
        return Collector.of(AlternateLinkedHashSet::new, HashSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collector.of(HashSet::new, Set::add, (left, right) -> {
            if (left.size() < right.size()) {
                right.addAll(left);
                return right;
            }
            left.addAll(right);
            return left;
        }, set -> Collections.unmodifiableSet(set), Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableLinkedSet() {
        return Collector.of(LinkedHashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, set -> Collections.unmodifiableSet(set), Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, LinkedList<T>> toLinkedList() {
        return Collector.of(LinkedList::new, LinkedList::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }
}

