/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.google.common.collect.AbstractIterator;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class SimpleVoxmap {
    private final byte[] data;
    private final boolean[] touched;
    private final int lenX;
    private final int lenY;
    private final int lenZ;
    private final int layerSize;
    BlockPos center = new BlockPos(0, 0, 0);

    public SimpleVoxmap(int lenX, int lenY, int lenZ) {
        this.data = new byte[lenX * lenY * lenZ];
        this.touched = new boolean[lenY];
        this.lenX = lenX;
        this.lenY = lenY;
        this.lenZ = lenZ;
        this.layerSize = lenX * lenZ;
    }

    public SimpleVoxmap(int lenX, int lenY, int lenZ, byte[] extData) {
        this.data = Arrays.copyOf(extData, lenX * lenY * lenZ);
        this.touched = new boolean[lenY];
        for (int y = 0; y < lenY; ++y) {
            this.touched[y] = true;
        }
        this.lenX = lenX;
        this.lenY = lenY;
        this.lenZ = lenZ;
        this.layerSize = lenX * lenZ;
    }

    public SimpleVoxmap(SimpleVoxmap vmp) {
        this(vmp.getLenX(), vmp.getLenY(), vmp.getLenZ(), vmp.data);
        this.center = vmp.center;
    }

    public SimpleVoxmap(BlockBounds bounds) {
        this(bounds.getXSize(), bounds.getYSize(), bounds.getZSize());
        this.setMapAndCenter(bounds.getMin(), new BlockPos(0, 0, 0));
    }

    public SimpleVoxmap setMapAndCenter(BlockPos mapPos, BlockPos centerPos) {
        this.setCenter(centerPos);
        this.center = this.center.m_121996_((Vec3i)mapPos);
        return this;
    }

    public SimpleVoxmap setMap(BlockPos mapPos) {
        this.center = this.center.m_121996_((Vec3i)mapPos);
        return this;
    }

    public SimpleVoxmap setCenter(BlockPos centerPos) {
        this.center = centerPos;
        return this;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLenX() {
        return this.lenX;
    }

    public int getLenY() {
        return this.lenY;
    }

    public int getLenZ() {
        return this.lenZ;
    }

    public BlockBounds getBounds() {
        int minX = this.center.m_123341_() - this.lenX + 1;
        int minY = this.center.m_123342_() - this.lenY + 1;
        int minZ = this.center.m_123343_() - this.lenZ + 1;
        int maxX = minX + this.lenX - 1;
        int maxY = minY + this.lenY - 1;
        int maxZ = minZ + this.lenZ - 1;
        return new BlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public SimpleVoxmap blitOp(BlockPos pos, SimpleVoxmap src, BlitOp op) {
        for (int iy = 0; iy < src.getLenY(); ++iy) {
            int srcY = iy - src.center.m_123342_();
            int dstY = pos.m_123342_() + srcY;
            this.setYTouched(dstY);
            for (int iz = 0; iz < src.getLenZ(); ++iz) {
                int srcZ = iz - src.center.m_123343_();
                int dstZ = pos.m_123343_() + srcZ;
                for (int ix = 0; ix < src.getLenX(); ++ix) {
                    int srcX = ix - src.center.m_123341_();
                    int dstX = pos.m_123341_() + srcX;
                    byte srcValue = src.getVoxel(srcX, srcY, srcZ);
                    byte dstValue = this.getVoxel(dstX, dstY, dstZ);
                    this.setVoxel(dstX, dstY, dstZ, op.getOp(srcValue, dstValue));
                }
            }
        }
        return this;
    }

    public SimpleVoxmap blitReplace(BlockPos pos, SimpleVoxmap src) {
        return this.blitOp(pos, src, (s, d) -> s);
    }

    public SimpleVoxmap blitMax(BlockPos pos, SimpleVoxmap src) {
        return this.blitOp(pos, src, (s, d) -> s >= d ? s : d);
    }

    public SimpleVoxmap blitClear(BlockPos pos, SimpleVoxmap src) {
        return this.blitOp(pos, src, (s, d) -> s >= 0 ? (byte)0 : d);
    }

    public SimpleVoxmap filter(FilterOp op) {
        Arrays.fill(this.touched, true);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = op.getOp(this.data[i]);
        }
        return this;
    }

    public SimpleVoxmap crop(BlockPos from, BlockPos to) {
        for (BlockPos.MutableBlockPos pos : this.getAllNonZero()) {
            if (pos.m_123341_() >= from.m_123341_() && pos.m_123342_() >= from.m_123342_() && pos.m_123343_() >= from.m_123343_() && pos.m_123341_() <= to.m_123341_() && pos.m_123342_() <= to.m_123342_() && pos.m_123343_() <= to.m_123343_()) continue;
            this.setVoxel((BlockPos)pos, (byte)0);
        }
        return this;
    }

    public SimpleVoxmap filter(BlockPos from, BlockPos to, FilterOp op) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)from, (BlockPos)to)) {
            this.setVoxel(pos, op.getOp(this.getVoxel(pos)));
        }
        return this;
    }

    public SimpleVoxmap fill(byte value) {
        return this.filter(v -> value);
    }

    public SimpleVoxmap fill(BlockPos from, BlockPos to, byte value) {
        return this.filter(from, to, v -> value);
    }

    private int calcPos(int x, int y, int z) {
        return y * this.lenX * this.lenZ + z * this.lenX + x;
    }

    public void setVoxel(BlockPos pos, byte value) {
        this.setVoxel(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), value);
    }

    public void setVoxelOr(BlockPos pos, byte value) {
        this.setVoxelOr(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), value);
    }

    public void setVoxel(int x, int y, int z, byte value) {
        if (this.testBounds(x += this.center.m_123341_(), y += this.center.m_123342_(), z += this.center.m_123343_())) {
            if (value != 0) {
                this.setYTouched(y - this.center.m_123342_());
            }
            this.data[this.calcPos((int)x, (int)y, (int)z)] = value;
        }
    }

    public void setVoxelOr(int x, int y, int z, byte value) {
        if (this.testBounds(x += this.center.m_123341_(), y += this.center.m_123342_(), z += this.center.m_123343_())) {
            if (value != 0) {
                this.setYTouched(y - this.center.m_123342_());
            }
            int n = this.calcPos(x, y, z);
            this.data[n] = (byte)(this.data[n] | value);
        }
    }

    public byte getVoxel(BlockPos relPos, BlockPos pos) {
        return this.getVoxel(pos.m_123341_() - relPos.m_123341_(), pos.m_123342_() - relPos.m_123342_(), pos.m_123343_() - relPos.m_123343_());
    }

    public byte getVoxel(BlockPos pos) {
        return this.getVoxel(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public byte getVoxel(int x, int y, int z) {
        if (this.isYTouched(y)) {
            return this.testBounds(x += this.center.m_123341_(), y += this.center.m_123342_(), z += this.center.m_123343_()) ? this.data[this.calcPos(x, y, z)] : (byte)0;
        }
        return 0;
    }

    private boolean testBounds(int x, int y, int z) {
        return x >= 0 && x < this.lenX && y >= 0 && y < this.lenY && z >= 0 && z < this.lenZ;
    }

    public boolean isYTouched(int y) {
        return (y += this.center.m_123342_()) >= 0 && y < this.lenY && this.touched[y];
    }

    public void setYTouched(int y) {
        if ((y += this.center.m_123342_()) >= 0 && y < this.lenY) {
            this.touched[y] = true;
        }
    }

    public Iterable<Cell> getAllNonZeroCells() {
        return this.getAllNonZeroCells((byte)-1);
    }

    public Iterable<Cell> getAllNonZeroCells(final byte mask) {
        return new Iterable<Cell>(){

            @Override
            public Iterator<Cell> iterator() {
                return new AbstractIterator<Cell>(){
                    private int x = -1;
                    private int y = 0;
                    private int z = 0;
                    private int dataPos = -1;
                    private final Cell workingCell = new Cell();
                    private final BlockPos.MutableBlockPos dPos = this.workingCell.getPos();

                    protected Cell computeNext() {
                        byte value;
                        block0: while (true) {
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                this.x = -1;
                                this.z = 0;
                                ++this.y;
                                while (this.y < SimpleVoxmap.this.lenY) {
                                    if (SimpleVoxmap.this.touched[this.y]) continue block0;
                                    this.dataPos += SimpleVoxmap.this.layerSize;
                                    ++this.y;
                                }
                                return (Cell)this.endOfData();
                            }
                            if ((value = (byte)(SimpleVoxmap.this.data[++this.dataPos] & mask)) > 0) break;
                        }
                        this.dPos.m_122178_(this.x - SimpleVoxmap.this.center.m_123341_(), this.y - SimpleVoxmap.this.center.m_123342_(), this.z - SimpleVoxmap.this.center.m_123343_());
                        return this.workingCell.setValue(value);
                    }
                };
            }
        };
    }

    public Iterable<BlockPos.MutableBlockPos> getAllNonZero() {
        return this.getAllNonZero((byte)-1);
    }

    public Iterable<BlockPos.MutableBlockPos> getAllNonZero(final byte mask) {
        return new Iterable<BlockPos.MutableBlockPos>(){

            @Override
            public Iterator<BlockPos.MutableBlockPos> iterator() {
                return new AbstractIterator<BlockPos.MutableBlockPos>(){
                    private int x = -1;
                    private int y = 0;
                    private int z = 0;
                    private int dataPos = -1;
                    private boolean yclean;
                    private final BlockPos.MutableBlockPos dPos = new BlockPos.MutableBlockPos();

                    protected BlockPos.MutableBlockPos computeNext() {
                        block0: while (true) {
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                this.x = -1;
                                this.z = 0;
                                SimpleVoxmap.this.touched[this.y] = !this.yclean;
                                ++this.y;
                                this.yclean = true;
                                while (this.y < SimpleVoxmap.this.lenY) {
                                    if (SimpleVoxmap.this.touched[this.y]) continue block0;
                                    this.dataPos += SimpleVoxmap.this.layerSize;
                                    ++this.y;
                                    this.yclean = true;
                                }
                                return (BlockPos.MutableBlockPos)this.endOfData();
                            }
                            if ((SimpleVoxmap.this.data[++this.dataPos] & mask) > 0) break;
                        }
                        this.yclean = false;
                        return this.dPos.m_122178_(this.x - SimpleVoxmap.this.center.m_123341_(), this.y - SimpleVoxmap.this.center.m_123342_(), this.z - SimpleVoxmap.this.center.m_123343_());
                    }
                };
            }
        };
    }

    public Iterable<BlockPos.MutableBlockPos> getTops() {
        return new Iterable<BlockPos.MutableBlockPos>(){

            @Override
            public Iterator<BlockPos.MutableBlockPos> iterator() {
                return new AbstractIterator<BlockPos.MutableBlockPos>(){
                    private int x = -1;
                    private int y = 0;
                    private int z = 0;
                    private final int yStart = this.getStartY();
                    private final BlockPos.MutableBlockPos dPos = new BlockPos.MutableBlockPos();

                    protected int getStartY() {
                        int yi;
                        for (yi = SimpleVoxmap.this.lenY - 1; yi >= 0 && !SimpleVoxmap.this.touched[yi]; --yi) {
                        }
                        return yi;
                    }

                    protected BlockPos.MutableBlockPos computeNext() {
                        block0: while (true) {
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                return (BlockPos.MutableBlockPos)this.endOfData();
                            }
                            this.y = this.yStart;
                            int dataPos = SimpleVoxmap.this.calcPos(this.x, this.y, this.z);
                            while (true) {
                                if (this.y < 0) continue block0;
                                if (SimpleVoxmap.this.data[dataPos] != 0) {
                                    return this.dPos.m_122178_(this.x - SimpleVoxmap.this.center.m_123341_(), this.y - SimpleVoxmap.this.center.m_123342_(), this.z - SimpleVoxmap.this.center.m_123343_());
                                }
                                dataPos -= SimpleVoxmap.this.layerSize;
                                --this.y;
                            }
                            break;
                        }
                    }
                };
            }
        };
    }

    public void print() {
        for (int y = 0; y < this.lenY; ++y) {
            StringBuilder buffer;
            System.out.println("Touched: " + this.touched[y]);
            for (int z = 0; z < this.lenZ; ++z) {
                buffer = new StringBuilder();
                for (int x = 0; x < this.lenX; ++x) {
                    byte b = this.getVoxel(x - this.center.m_123341_(), y - this.center.m_123342_(), z - this.center.m_123343_());
                    if ((b & 0x20) != 0) {
                        buffer.append("B");
                        continue;
                    }
                    if ((b & 0x10) != 0) {
                        buffer.append("T");
                        continue;
                    }
                    buffer.append(Integer.toHexString(b & 0xF));
                }
                System.out.println(buffer);
            }
            buffer = new StringBuilder();
            for (int k = 0; k < this.lenX; ++k) {
                buffer.append("-");
            }
            System.out.println(buffer);
        }
    }

    @FunctionalInterface
    public static interface BlitOp {
        public byte getOp(byte var1, byte var2);
    }

    @FunctionalInterface
    public static interface FilterOp {
        public byte getOp(byte var1);
    }

    public static class Cell {
        private byte value;
        private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

        public Cell setValue(byte value) {
            this.value = value;
            return this;
        }

        public byte getValue() {
            return this.value;
        }

        public BlockPos.MutableBlockPos getPos() {
            return this.pos;
        }
    }
}

